<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateRangeType Structs
 * @subpackage Structs
 */
class DateRangeType extends AbstractStructBase
{
    /**
     * The OutboundDate
     * Meta informations extracted from the WSDL
     * - documentation: Outbound date
     * @var string
     */
    public $OutboundDate;
    /**
     * The DateRange
     * Meta informations extracted from the WSDL
     * - documentation: Number of date range
     * @var int
     */
    public $DateRange;
    /**
     * Constructor method for DateRangeType
     * @uses DateRangeType::setOutboundDate()
     * @uses DateRangeType::setDateRange()
     * @param string $outboundDate
     * @param int $dateRange
     */
    public function __construct($outboundDate = null, $dateRange = null)
    {
        $this
            ->setOutboundDate($outboundDate)
            ->setDateRange($dateRange);
    }
    /**
     * Get OutboundDate value
     * @return string|null
     */
    public function getOutboundDate()
    {
        return $this->OutboundDate;
    }
    /**
     * Set OutboundDate value
     * @param string $outboundDate
     * @return \Sabre\BargainFinderMax\Structs\DateRangeType
     */
    public function setOutboundDate($outboundDate = null)
    {
        $this->OutboundDate = $outboundDate;
        return $this;
    }
    /**
     * Get DateRange value
     * @return int|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param int $dateRange
     * @return \Sabre\BargainFinderMax\Structs\DateRangeType
     */
    public function setDateRange($dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DateRangeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
