<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyConversionType Structs
 * @subpackage Structs
 */
class CurrencyConversionType extends AbstractStructBase
{
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - documentation: from currency Tag | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - documentation: to currency Tag | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $To;
    /**
     * The Overriden
     * Meta informations extracted from the WSDL
     * - documentation: Conversion overriden
     * - use: optional
     * @var bool
     */
    public $Overriden;
    /**
     * The ExchangeRateUsed
     * Meta informations extracted from the WSDL
     * - documentation: Exchange rate used for the currency conversion
     * - use: optional
     * @var float
     */
    public $ExchangeRateUsed;
    /**
     * The ExchangeRate
     * Meta informations extracted from the WSDL
     * - documentation: exchange rate
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * Constructor method for CurrencyConversionType
     * @uses CurrencyConversionType::setFrom()
     * @uses CurrencyConversionType::setTo()
     * @uses CurrencyConversionType::setOverriden()
     * @uses CurrencyConversionType::setExchangeRateUsed()
     * @uses CurrencyConversionType::setExchangeRate()
     * @param string $from
     * @param string $to
     * @param bool $overriden
     * @param float $exchangeRateUsed
     * @param float $exchangeRate
     */
    public function __construct($from = null, $to = null, $overriden = null, $exchangeRateUsed = null, $exchangeRate = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setOverriden($overriden)
            ->setExchangeRateUsed($exchangeRateUsed)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public function setFrom($from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public function setTo($to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get Overriden value
     * @return bool|null
     */
    public function getOverriden()
    {
        return $this->Overriden;
    }
    /**
     * Set Overriden value
     * @param bool $overriden
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public function setOverriden($overriden = null)
    {
        $this->Overriden = $overriden;
        return $this;
    }
    /**
     * Get ExchangeRateUsed value
     * @return float|null
     */
    public function getExchangeRateUsed()
    {
        return $this->ExchangeRateUsed;
    }
    /**
     * Set ExchangeRateUsed value
     * @param float $exchangeRateUsed
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public function setExchangeRateUsed($exchangeRateUsed = null)
    {
        $this->ExchangeRateUsed = $exchangeRateUsed;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
