<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocation Structs
 * @subpackage Structs
 */
class ConnectionLocation extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: IATA Airport Code indicating connection location, stop, origin or destination. | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $LocationCode;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Only
     * - documentation: The preference level for the airport. Available levels: Only, Unacceptable.
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for ConnectionLocation
     * @uses ConnectionLocation::set_()
     * @uses ConnectionLocation::setLocationCode()
     * @uses ConnectionLocation::setPreferLevel()
     * @param string $_
     * @param string $locationCode
     * @param string $preferLevel
     */
    public function __construct($_ = null, $locationCode = null, $preferLevel = 'Only')
    {
        $this
            ->set_($_)
            ->setLocationCode($locationCode)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\ConnectionLocation
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\BargainFinderMax\Structs\ConnectionLocation
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\AllowedExcludedPreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\AllowedExcludedPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\ConnectionLocation
     */
    public function setPreferLevel($preferLevel = 'Only')
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ConnectionLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
