<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cat16TextOnly Structs
 * Meta informations extracted from the WSDL
 * - documentation: Missing Data | Missing Data
 * @subpackage Structs
 */
class Cat16TextOnly extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - documentation: Fare basis code | Fare basis code
     * - use: required
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareComponentID
     * Meta informations extracted from the WSDL
     * - documentation: Fare component Id | Fare component Id
     * - use: required
     * @var int
     */
    public $FareComponentID;
    /**
     * Constructor method for Cat16TextOnly
     * @uses Cat16TextOnly::setFareBasisCode()
     * @uses Cat16TextOnly::setFareComponentID()
     * @param string $fareBasisCode
     * @param int $fareComponentID
     */
    public function __construct($fareBasisCode = null, $fareComponentID = null)
    {
        $this
            ->setFareBasisCode($fareBasisCode)
            ->setFareComponentID($fareComponentID);
    }
    /**
     * Get FareBasisCode value
     * @return string
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \Sabre\BargainFinderMax\Structs\Cat16TextOnly
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareComponentID value
     * @return int
     */
    public function getFareComponentID()
    {
        return $this->FareComponentID;
    }
    /**
     * Set FareComponentID value
     * @param int $fareComponentID
     * @return \Sabre\BargainFinderMax\Structs\Cat16TextOnly
     */
    public function setFareComponentID($fareComponentID = null)
    {
        $this->FareComponentID = $fareComponentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Cat16TextOnly
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
