<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carrier Structs
 * Meta informations extracted from the WSDL
 * - documentation: Carrier Information | Specifies desired order of carriers | Specifies desired order of carriers
 * - type: CarrierCode
 * - use: required
 * @subpackage Structs
 */
class Carrier extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Code;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var float
     */
    public $Weight;
    /**
     * The Marketing
     * Meta informations extracted from the WSDL
     * - documentation: Marketing Carrier | Airline carrier code type
     * - use: required
     * - pattern: \*\*
     * @var string
     */
    public $Marketing;
    /**
     * The MarketingFlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: Marketing Flight Number
     * - use: required
     * @var int
     */
    public $MarketingFlightNumber;
    /**
     * The Operating
     * Meta informations extracted from the WSDL
     * - documentation: Operating Carrier | Airline carrier code type
     * - use: required
     * - pattern: \*\*
     * @var string
     */
    public $Operating;
    /**
     * The Default
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\_Default
     */
    public $Default;
    /**
     * The Override
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Override[]
     */
    public $Override;
    /**
     * The OnlineIndicator
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $OnlineIndicator;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Equipment
     */
    public $Equipment;
    /**
     * The OperatingFlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: Operating Flight Number
     * @var int
     */
    public $OperatingFlightNumber;
    /**
     * The Disclosure
     * Meta informations extracted from the WSDL
     * - documentation: Disclosure Carrier | Airline carrier code type
     * - pattern: \*\*
     * @var string
     */
    public $Disclosure;
    /**
     * The CallDirect
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Call Direct Carrier
     * @var bool
     */
    public $CallDirect;
    /**
     * The CodeShared
     * Meta informations extracted from the WSDL
     * - documentation: Code Shared Carrier
     * @var string
     */
    public $CodeShared;
    /**
     * The Alliances
     * Meta informations extracted from the WSDL
     * - documentation: Alliances
     * @var string
     */
    public $Alliances;
    /**
     * The BasicBookingRequest
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Basic Booking Request Carrier
     * @var bool
     */
    public $BasicBookingRequest;
    /**
     * Constructor method for Carrier
     * @uses Carrier::setCode()
     * @uses Carrier::setWeight()
     * @uses Carrier::setMarketing()
     * @uses Carrier::setMarketingFlightNumber()
     * @uses Carrier::setOperating()
     * @uses Carrier::setDefault()
     * @uses Carrier::setOverride()
     * @uses Carrier::setOnlineIndicator()
     * @uses Carrier::setEquipment()
     * @uses Carrier::setOperatingFlightNumber()
     * @uses Carrier::setDisclosure()
     * @uses Carrier::setCallDirect()
     * @uses Carrier::setCodeShared()
     * @uses Carrier::setAlliances()
     * @uses Carrier::setBasicBookingRequest()
     * @param string $code
     * @param float $weight
     * @param string $marketing
     * @param int $marketingFlightNumber
     * @param string $operating
     * @param \Sabre\BargainFinderMax\Structs\_Default $default
     * @param \Sabre\BargainFinderMax\Structs\Override[] $override
     * @param bool $onlineIndicator
     * @param \Sabre\BargainFinderMax\Structs\Equipment $equipment
     * @param int $operatingFlightNumber
     * @param string $disclosure
     * @param bool $callDirect
     * @param string $codeShared
     * @param string $alliances
     * @param bool $basicBookingRequest
     */
    public function __construct($code = null, $weight = null, $marketing = null, $marketingFlightNumber = null, $operating = null, \Sabre\BargainFinderMax\Structs\_Default $default = null, array $override = array(), $onlineIndicator = false, \Sabre\BargainFinderMax\Structs\Equipment $equipment = null, $operatingFlightNumber = null, $disclosure = null, $callDirect = false, $codeShared = null, $alliances = null, $basicBookingRequest = false)
    {
        $this
            ->setCode($code)
            ->setWeight($weight)
            ->setMarketing($marketing)
            ->setMarketingFlightNumber($marketingFlightNumber)
            ->setOperating($operating)
            ->setDefault($default)
            ->setOverride($override)
            ->setOnlineIndicator($onlineIndicator)
            ->setEquipment($equipment)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setDisclosure($disclosure)
            ->setCallDirect($callDirect)
            ->setCodeShared($codeShared)
            ->setAlliances($alliances)
            ->setBasicBookingRequest($basicBookingRequest);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Marketing value
     * @return string
     */
    public function getMarketing()
    {
        return $this->Marketing;
    }
    /**
     * Set Marketing value
     * @param string $marketing
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setMarketing($marketing = null)
    {
        $this->Marketing = $marketing;
        return $this;
    }
    /**
     * Get MarketingFlightNumber value
     * @return int
     */
    public function getMarketingFlightNumber()
    {
        return $this->MarketingFlightNumber;
    }
    /**
     * Set MarketingFlightNumber value
     * @param int $marketingFlightNumber
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setMarketingFlightNumber($marketingFlightNumber = null)
    {
        $this->MarketingFlightNumber = $marketingFlightNumber;
        return $this;
    }
    /**
     * Get Operating value
     * @return string
     */
    public function getOperating()
    {
        return $this->Operating;
    }
    /**
     * Set Operating value
     * @param string $operating
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setOperating($operating = null)
    {
        $this->Operating = $operating;
        return $this;
    }
    /**
     * Get Default value
     * @return \Sabre\BargainFinderMax\Structs\_Default|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param \Sabre\BargainFinderMax\Structs\_Default $default
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setDefault(\Sabre\BargainFinderMax\Structs\_Default $default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Override value
     * @return \Sabre\BargainFinderMax\Structs\Override[]|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Override[] $override
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setOverride(array $override = array())
    {
        $this->Override = $override;
        return $this;
    }
    /**
     * Add item to Override value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Override $item
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function addToOverride(\Sabre\BargainFinderMax\Structs\Override $item)
    {
        $this->Override[] = $item;
        return $this;
    }
    /**
     * Get OnlineIndicator value
     * @return bool|null
     */
    public function getOnlineIndicator()
    {
        return $this->OnlineIndicator;
    }
    /**
     * Set OnlineIndicator value
     * @param bool $onlineIndicator
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setOnlineIndicator($onlineIndicator = false)
    {
        $this->OnlineIndicator = $onlineIndicator;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \Sabre\BargainFinderMax\Structs\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \Sabre\BargainFinderMax\Structs\Equipment $equipment
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setEquipment(\Sabre\BargainFinderMax\Structs\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * @return int|null
     */
    public function getOperatingFlightNumber()
    {
        return $this->OperatingFlightNumber;
    }
    /**
     * Set OperatingFlightNumber value
     * @param int $operatingFlightNumber
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        $this->OperatingFlightNumber = $operatingFlightNumber;
        return $this;
    }
    /**
     * Get Disclosure value
     * @return string|null
     */
    public function getDisclosure()
    {
        return $this->Disclosure;
    }
    /**
     * Set Disclosure value
     * @param string $disclosure
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setDisclosure($disclosure = null)
    {
        $this->Disclosure = $disclosure;
        return $this;
    }
    /**
     * Get CallDirect value
     * @return bool|null
     */
    public function getCallDirect()
    {
        return $this->CallDirect;
    }
    /**
     * Set CallDirect value
     * @param bool $callDirect
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setCallDirect($callDirect = false)
    {
        $this->CallDirect = $callDirect;
        return $this;
    }
    /**
     * Get CodeShared value
     * @return string|null
     */
    public function getCodeShared()
    {
        return $this->CodeShared;
    }
    /**
     * Set CodeShared value
     * @param string $codeShared
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setCodeShared($codeShared = null)
    {
        $this->CodeShared = $codeShared;
        return $this;
    }
    /**
     * Get Alliances value
     * @return string|null
     */
    public function getAlliances()
    {
        return $this->Alliances;
    }
    /**
     * Set Alliances value
     * @param string $alliances
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setAlliances($alliances = null)
    {
        $this->Alliances = $alliances;
        return $this;
    }
    /**
     * Get BasicBookingRequest value
     * @return bool|null
     */
    public function getBasicBookingRequest()
    {
        return $this->BasicBookingRequest;
    }
    /**
     * Set BasicBookingRequest value
     * @param bool $basicBookingRequest
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public function setBasicBookingRequest($basicBookingRequest = false)
    {
        $this->BasicBookingRequest = $basicBookingRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Carrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
