<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CacheSourceDescType Structs
 * @subpackage Structs
 */
class CacheSourceDescType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Cache Source ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The Partition
     * Meta informations extracted from the WSDL
     * - documentation: Indicates source partition of cached itin
     * - use: required
     * @var string
     */
    public $Partition;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Indicates source partition priority of cached itin
     * @var int
     */
    public $Priority;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: Indicates source version of cached itin
     * @var string
     */
    public $Version;
    /**
     * Constructor method for CacheSourceDescType
     * @uses CacheSourceDescType::setID()
     * @uses CacheSourceDescType::setPartition()
     * @uses CacheSourceDescType::setPriority()
     * @uses CacheSourceDescType::setVersion()
     * @param int $iD
     * @param string $partition
     * @param int $priority
     * @param string $version
     */
    public function __construct($iD = null, $partition = null, $priority = null, $version = null)
    {
        $this
            ->setID($iD)
            ->setPartition($partition)
            ->setPriority($priority)
            ->setVersion($version);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\CacheSourceDescType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Partition value
     * @return string
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param string $partition
     * @return \Sabre\BargainFinderMax\Structs\CacheSourceDescType
     */
    public function setPartition($partition = null)
    {
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \Sabre\BargainFinderMax\Structs\CacheSourceDescType
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\BargainFinderMax\Structs\CacheSourceDescType
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CacheSourceDescType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
