<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandedOneWayItineraries Structs
 * Meta informations extracted from the WSDL
 * - documentation: Container for priced itineraries assigned to particular leg. | Container for priced itineraries assigned to particular leg. | Container for priced itineraries assigned to particular leg. | Container for priced itineraries assigned to
 * particular leg.
 * @subpackage Structs
 */
class BrandedOneWayItineraries extends AbstractStructBase
{
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: Leg ID from request. | Leg ID from request. | Leg ID from request. | Leg ID from request. | (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual
     * passengers or clients to particular itinerary items.
     * - use: required
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - documentation: Container for priced itinerary type. | Container for priced itinerary type. | Container for priced itinerary type. | Container for priced itinerary type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PricedItineraryType[]
     */
    public $PricedItinerary;
    /**
     * Constructor method for BrandedOneWayItineraries
     * @uses BrandedOneWayItineraries::setRPH()
     * @uses BrandedOneWayItineraries::setTPA_Extensions()
     * @uses BrandedOneWayItineraries::setPricedItinerary()
     * @param string $rPH
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType[] $pricedItinerary
     */
    public function __construct($rPH = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, array $pricedItinerary = array())
    {
        $this
            ->setRPH($rPH)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricedItinerary($pricedItinerary);
    }
    /**
     * Get RPH value
     * @return string
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\BargainFinderMax\Structs\BrandedOneWayItineraries
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\BrandedOneWayItineraries
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PricedItinerary value
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType[] $pricedItinerary
     * @return \Sabre\BargainFinderMax\Structs\BrandedOneWayItineraries
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType $item
     * @return \Sabre\BargainFinderMax\Structs\BrandedOneWayItineraries
     */
    public function addToPricedItinerary(\Sabre\BargainFinderMax\Structs\PricedItineraryType $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BrandedOneWayItineraries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
