<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandedFareIndicators Structs
 * @subpackage Structs
 */
class BrandedFareIndicators extends AbstractStructBase
{
    /**
     * The ReturnCheapestUnbrandedFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ReturnCheapestUnbrandedFare
     */
    public $ReturnCheapestUnbrandedFare;
    /**
     * The SingleBrandedFare
     * Meta informations extracted from the WSDL
     * - documentation: Return single brand option per itin
     * - use: optional
     * @var bool
     */
    public $SingleBrandedFare;
    /**
     * The MultipleBrandedFares
     * Meta informations extracted from the WSDL
     * - documentation: Return multiple brand options per itin
     * - use: optional
     * @var bool
     */
    public $MultipleBrandedFares;
    /**
     * The ReturnBrandAncillaries
     * Meta informations extracted from the WSDL
     * - documentation: Return ancillaries from the ATPCO Branded Fares Feature Table 166
     * - use: optional
     * @var bool
     */
    public $ReturnBrandAncillaries;
    /**
     * Constructor method for BrandedFareIndicators
     * @uses BrandedFareIndicators::setReturnCheapestUnbrandedFare()
     * @uses BrandedFareIndicators::setSingleBrandedFare()
     * @uses BrandedFareIndicators::setMultipleBrandedFares()
     * @uses BrandedFareIndicators::setReturnBrandAncillaries()
     * @param \Sabre\BargainFinderMax\Structs\ReturnCheapestUnbrandedFare $returnCheapestUnbrandedFare
     * @param bool $singleBrandedFare
     * @param bool $multipleBrandedFares
     * @param bool $returnBrandAncillaries
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ReturnCheapestUnbrandedFare $returnCheapestUnbrandedFare = null, $singleBrandedFare = null, $multipleBrandedFares = null, $returnBrandAncillaries = null)
    {
        $this
            ->setReturnCheapestUnbrandedFare($returnCheapestUnbrandedFare)
            ->setSingleBrandedFare($singleBrandedFare)
            ->setMultipleBrandedFares($multipleBrandedFares)
            ->setReturnBrandAncillaries($returnBrandAncillaries);
    }
    /**
     * Get ReturnCheapestUnbrandedFare value
     * @return \Sabre\BargainFinderMax\Structs\ReturnCheapestUnbrandedFare|null
     */
    public function getReturnCheapestUnbrandedFare()
    {
        return $this->ReturnCheapestUnbrandedFare;
    }
    /**
     * Set ReturnCheapestUnbrandedFare value
     * @param \Sabre\BargainFinderMax\Structs\ReturnCheapestUnbrandedFare $returnCheapestUnbrandedFare
     * @return \Sabre\BargainFinderMax\Structs\BrandedFareIndicators
     */
    public function setReturnCheapestUnbrandedFare(\Sabre\BargainFinderMax\Structs\ReturnCheapestUnbrandedFare $returnCheapestUnbrandedFare = null)
    {
        $this->ReturnCheapestUnbrandedFare = $returnCheapestUnbrandedFare;
        return $this;
    }
    /**
     * Get SingleBrandedFare value
     * @return bool|null
     */
    public function getSingleBrandedFare()
    {
        return $this->SingleBrandedFare;
    }
    /**
     * Set SingleBrandedFare value
     * @param bool $singleBrandedFare
     * @return \Sabre\BargainFinderMax\Structs\BrandedFareIndicators
     */
    public function setSingleBrandedFare($singleBrandedFare = null)
    {
        $this->SingleBrandedFare = $singleBrandedFare;
        return $this;
    }
    /**
     * Get MultipleBrandedFares value
     * @return bool|null
     */
    public function getMultipleBrandedFares()
    {
        return $this->MultipleBrandedFares;
    }
    /**
     * Set MultipleBrandedFares value
     * @param bool $multipleBrandedFares
     * @return \Sabre\BargainFinderMax\Structs\BrandedFareIndicators
     */
    public function setMultipleBrandedFares($multipleBrandedFares = null)
    {
        $this->MultipleBrandedFares = $multipleBrandedFares;
        return $this;
    }
    /**
     * Get ReturnBrandAncillaries value
     * @return bool|null
     */
    public function getReturnBrandAncillaries()
    {
        return $this->ReturnBrandAncillaries;
    }
    /**
     * Set ReturnBrandAncillaries value
     * @param bool $returnBrandAncillaries
     * @return \Sabre\BargainFinderMax\Structs\BrandedFareIndicators
     */
    public function setReturnBrandAncillaries($returnBrandAncillaries = null)
    {
        $this->ReturnBrandAncillaries = $returnBrandAncillaries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BrandedFareIndicators
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
