<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandFeatureRefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Reference to ATPCO Table 166 brand feature item
 * @subpackage Structs
 */
class BrandFeatureRefType extends AbstractStructBase
{
    /**
     * The FeatureId
     * Meta informations extracted from the WSDL
     * - documentation: Index to the final brand feature items list
     * - use: required
     * @var int
     */
    public $FeatureId;
    /**
     * Constructor method for BrandFeatureRefType
     * @uses BrandFeatureRefType::setFeatureId()
     * @param int $featureId
     */
    public function __construct($featureId = null)
    {
        $this
            ->setFeatureId($featureId);
    }
    /**
     * Get FeatureId value
     * @return int
     */
    public function getFeatureId()
    {
        return $this->FeatureId;
    }
    /**
     * Set FeatureId value
     * @param int $featureId
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureRefType
     */
    public function setFeatureId($featureId = null)
    {
        $this->FeatureId = $featureId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureRefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
