<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Baggage Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element allows user to get baggage information | This element allows user to get baggage information
 * @subpackage Structs
 */
class Baggage extends AbstractStructBase
{
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - documentation: Determines type of baggage processing result.
     * - use: required
     * @var string
     */
    public $RequestType;
    /**
     * The FreePieceRequired
     * Meta informations extracted from the WSDL
     * - documentation: Free baggage piece is required. | Free baggage piece is required on the whole journey.
     * - use: optional
     * @var bool
     */
    public $FreePieceRequired;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Turns on additional text output in response, see Description1 (D01) and Description2 (D02) in response.
     * - use: optional
     * @var bool
     */
    public $Description;
    /**
     * The RequestedPieces
     * Meta informations extracted from the WSDL
     * - documentation: Number of baggage pieces requested
     * - use: optional
     * @var int
     */
    public $RequestedPieces;
    /**
     * Constructor method for Baggage
     * @uses Baggage::setRequestType()
     * @uses Baggage::setFreePieceRequired()
     * @uses Baggage::setDescription()
     * @uses Baggage::setRequestedPieces()
     * @param string $requestType
     * @param bool $freePieceRequired
     * @param bool $description
     * @param int $requestedPieces
     */
    public function __construct($requestType = null, $freePieceRequired = null, $description = false, $requestedPieces = null)
    {
        $this
            ->setRequestType($requestType)
            ->setFreePieceRequired($freePieceRequired)
            ->setDescription($description)
            ->setRequestedPieces($requestedPieces);
    }
    /**
     * Get RequestType value
     * @return string
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \Sabre\BargainFinderMax\Enums\BaggageRequestType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\BaggageRequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \Sabre\BargainFinderMax\Structs\Baggage
     */
    public function setRequestType($requestType = null)
    {
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get FreePieceRequired value
     * @return bool|null
     */
    public function getFreePieceRequired()
    {
        return $this->FreePieceRequired;
    }
    /**
     * Set FreePieceRequired value
     * @param bool $freePieceRequired
     * @return \Sabre\BargainFinderMax\Structs\Baggage
     */
    public function setFreePieceRequired($freePieceRequired = null)
    {
        $this->FreePieceRequired = $freePieceRequired;
        return $this;
    }
    /**
     * Get Description value
     * @return bool|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param bool $description
     * @return \Sabre\BargainFinderMax\Structs\Baggage
     */
    public function setDescription($description = false)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RequestedPieces value
     * @return int|null
     */
    public function getRequestedPieces()
    {
        return $this->RequestedPieces;
    }
    /**
     * Set RequestedPieces value
     * @param int $requestedPieces
     * @return \Sabre\BargainFinderMax\Structs\Baggage
     */
    public function setRequestedPieces($requestedPieces = null)
    {
        $this->RequestedPieces = $requestedPieces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Baggage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
