<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFees Structs
 * @subpackage Structs
 */
class AncillaryFees extends AbstractStructBase
{
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - documentation: Enable Ancillary Fees processing path.
     * - use: required
     * @var bool
     */
    public $Enable;
    /**
     * The AncillaryFeeGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup[]
     */
    public $AncillaryFeeGroup;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - documentation: Flag whether this is a summary request.
     * @var bool
     */
    public $Summary;
    /**
     * Constructor method for AncillaryFees
     * @uses AncillaryFees::setEnable()
     * @uses AncillaryFees::setAncillaryFeeGroup()
     * @uses AncillaryFees::setSummary()
     * @param bool $enable
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup[] $ancillaryFeeGroup
     * @param bool $summary
     */
    public function __construct($enable = null, array $ancillaryFeeGroup = array(), $summary = null)
    {
        $this
            ->setEnable($enable)
            ->setAncillaryFeeGroup($ancillaryFeeGroup)
            ->setSummary($summary);
    }
    /**
     * Get Enable value
     * @return bool
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param bool $enable
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFees
     */
    public function setEnable($enable = null)
    {
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Get AncillaryFeeGroup value
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup[]|null
     */
    public function getAncillaryFeeGroup()
    {
        return $this->AncillaryFeeGroup;
    }
    /**
     * Set AncillaryFeeGroup value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup[] $ancillaryFeeGroup
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFees
     */
    public function setAncillaryFeeGroup(array $ancillaryFeeGroup = array())
    {
        $this->AncillaryFeeGroup = $ancillaryFeeGroup;
        return $this;
    }
    /**
     * Add item to AncillaryFeeGroup value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup $item
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFees
     */
    public function addToAncillaryFeeGroup(\Sabre\BargainFinderMax\Structs\AncillaryFeeGroup $item)
    {
        $this->AncillaryFeeGroup[] = $item;
        return $this;
    }
    /**
     * Get Summary value
     * @return bool|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param bool $summary
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFees
     */
    public function setSummary($summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
