<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternatePCCType Structs
 * @subpackage Structs
 */
class AlternatePCCType extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16
     * - use: required
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The TravelPreferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TravelPreferences
     */
    public $TravelPreferences;
    /**
     * Constructor method for AlternatePCCType
     * @uses AlternatePCCType::setPseudoCityCode()
     * @uses AlternatePCCType::setTravelPreferences()
     * @param string $pseudoCityCode
     * @param \Sabre\BargainFinderMax\Structs\TravelPreferences $travelPreferences
     */
    public function __construct($pseudoCityCode = null, \Sabre\BargainFinderMax\Structs\TravelPreferences $travelPreferences = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setTravelPreferences($travelPreferences);
    }
    /**
     * Get PseudoCityCode value
     * @return string
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\BargainFinderMax\Structs\AlternatePCCType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \Sabre\BargainFinderMax\Structs\TravelPreferences|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \Sabre\BargainFinderMax\Structs\TravelPreferences $travelPreferences
     * @return \Sabre\BargainFinderMax\Structs\AlternatePCCType
     */
    public function setTravelPreferences(\Sabre\BargainFinderMax\Structs\TravelPreferences $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AlternatePCCType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
