<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateAirportCities Structs
 * Meta informations extracted from the WSDL
 * - documentation: For each specified location provide an alternate location.
 * @subpackage Structs
 */
class AlternateAirportCities extends AbstractStructBase
{
    /**
     * The SpecifiedLocation
     * @var \Sabre\BargainFinderMax\Structs\SpecifiedLocation
     */
    public $SpecifiedLocation;
    /**
     * The AlternateLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * @var \Sabre\BargainFinderMax\Structs\AlternateLocation[]
     */
    public $AlternateLocation;
    /**
     * Constructor method for AlternateAirportCities
     * @uses AlternateAirportCities::setSpecifiedLocation()
     * @uses AlternateAirportCities::setAlternateLocation()
     * @param \Sabre\BargainFinderMax\Structs\SpecifiedLocation $specifiedLocation
     * @param \Sabre\BargainFinderMax\Structs\AlternateLocation[] $alternateLocation
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\SpecifiedLocation $specifiedLocation = null, array $alternateLocation = array())
    {
        $this
            ->setSpecifiedLocation($specifiedLocation)
            ->setAlternateLocation($alternateLocation);
    }
    /**
     * Get SpecifiedLocation value
     * @return \Sabre\BargainFinderMax\Structs\SpecifiedLocation|null
     */
    public function getSpecifiedLocation()
    {
        return $this->SpecifiedLocation;
    }
    /**
     * Set SpecifiedLocation value
     * @param \Sabre\BargainFinderMax\Structs\SpecifiedLocation $specifiedLocation
     * @return \Sabre\BargainFinderMax\Structs\AlternateAirportCities
     */
    public function setSpecifiedLocation(\Sabre\BargainFinderMax\Structs\SpecifiedLocation $specifiedLocation = null)
    {
        $this->SpecifiedLocation = $specifiedLocation;
        return $this;
    }
    /**
     * Get AlternateLocation value
     * @return \Sabre\BargainFinderMax\Structs\AlternateLocation[]|null
     */
    public function getAlternateLocation()
    {
        return $this->AlternateLocation;
    }
    /**
     * Set AlternateLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AlternateLocation[] $alternateLocation
     * @return \Sabre\BargainFinderMax\Structs\AlternateAirportCities
     */
    public function setAlternateLocation(array $alternateLocation = array())
    {
        $this->AlternateLocation = $alternateLocation;
        return $this;
    }
    /**
     * Add item to AlternateLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AlternateLocation $item
     * @return \Sabre\BargainFinderMax\Structs\AlternateAirportCities
     */
    public function addToAlternateLocation(\Sabre\BargainFinderMax\Structs\AlternateLocation $item)
    {
        $this->AlternateLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AlternateAirportCities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
