<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Information about the person traveling. Gender - the gender of the customer, if needed. BirthDate - Date of Birth. Currency - the preferred currency in which monetary amounts should be returned.
 * @subpackage Structs
 */
class AirTravelerType extends AbstractStructBase
{
    /**
     * The PassengerTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: A three-letter code representing passenger type (e.g. .ADT. for adult, .CNN. for child) | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: required
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The ProfileRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ProfileRef
     */
    public $ProfileRef;
    /**
     * The PersonName
     * @var \Sabre\BargainFinderMax\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TelephoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\EmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AddressType[]
     */
    public $Address;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - documentation: Specify a customer loyalty program.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CustLoyaltyType[]
     */
    public $CustLoyalty;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DocumentType[]
     */
    public $Document;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Define information on the number of passengers of a specific type.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - documentation: Direct reference of traveler assigned by requesting system. Used as a cross reference between data segments.
     * @var \Sabre\BargainFinderMax\Structs\TravelerRefNumberType
     */
    public $TravelerRefNumber;
    /**
     * The FlightSegmentRPHs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FlightSegmentRPHs
     */
    public $FlightSegmentRPHs;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Date of Birth.
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: The preferred currency in which monetary amounts should be returned. | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AccompaniedByInfant
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if an infant accompanying a traveler is with or without a seat.
     * - use: optional
     * @var bool
     */
    public $AccompaniedByInfant;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AirTravelerType
     * @uses AirTravelerType::setPassengerTypeCode()
     * @uses AirTravelerType::setProfileRef()
     * @uses AirTravelerType::setPersonName()
     * @uses AirTravelerType::setTelephone()
     * @uses AirTravelerType::setEmail()
     * @uses AirTravelerType::setAddress()
     * @uses AirTravelerType::setCustLoyalty()
     * @uses AirTravelerType::setDocument()
     * @uses AirTravelerType::setPassengerTypeQuantity()
     * @uses AirTravelerType::setTravelerRefNumber()
     * @uses AirTravelerType::setFlightSegmentRPHs()
     * @uses AirTravelerType::setBirthDate()
     * @uses AirTravelerType::setCurrencyCode()
     * @uses AirTravelerType::setAccompaniedByInfant()
     * @uses AirTravelerType::setGender()
     * @uses AirTravelerType::setShareSynchInd()
     * @uses AirTravelerType::setShareMarketInd()
     * @param string $passengerTypeCode
     * @param \Sabre\BargainFinderMax\Structs\ProfileRef $profileRef
     * @param \Sabre\BargainFinderMax\Structs\PersonNameType $personName
     * @param \Sabre\BargainFinderMax\Structs\TelephoneType[] $telephone
     * @param \Sabre\BargainFinderMax\Structs\EmailType[] $email
     * @param \Sabre\BargainFinderMax\Structs\AddressType[] $address
     * @param \Sabre\BargainFinderMax\Structs\CustLoyaltyType[] $custLoyalty
     * @param \Sabre\BargainFinderMax\Structs\DocumentType[] $document
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity
     * @param \Sabre\BargainFinderMax\Structs\TravelerRefNumberType $travelerRefNumber
     * @param \Sabre\BargainFinderMax\Structs\FlightSegmentRPHs $flightSegmentRPHs
     * @param string $birthDate
     * @param string $currencyCode
     * @param bool $accompaniedByInfant
     * @param string $gender
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct($passengerTypeCode = null, \Sabre\BargainFinderMax\Structs\ProfileRef $profileRef = null, \Sabre\BargainFinderMax\Structs\PersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $custLoyalty = array(), array $document = array(), \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity = null, \Sabre\BargainFinderMax\Structs\TravelerRefNumberType $travelerRefNumber = null, \Sabre\BargainFinderMax\Structs\FlightSegmentRPHs $flightSegmentRPHs = null, $birthDate = null, $currencyCode = null, $accompaniedByInfant = null, $gender = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setPassengerTypeCode($passengerTypeCode)
            ->setProfileRef($profileRef)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setCustLoyalty($custLoyalty)
            ->setDocument($document)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setFlightSegmentRPHs($flightSegmentRPHs)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setAccompaniedByInfant($accompaniedByInfant)
            ->setGender($gender)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get PassengerTypeCode value
     * @return string
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get ProfileRef value
     * @return \Sabre\BargainFinderMax\Structs\ProfileRef|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param \Sabre\BargainFinderMax\Structs\ProfileRef $profileRef
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setProfileRef(\Sabre\BargainFinderMax\Structs\ProfileRef $profileRef = null)
    {
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\BargainFinderMax\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\BargainFinderMax\Structs\PersonNameType $personName
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setPersonName(\Sabre\BargainFinderMax\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TelephoneType[] $telephone
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TelephoneType $item
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function addToTelephone(\Sabre\BargainFinderMax\Structs\TelephoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\BargainFinderMax\Structs\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\EmailType[] $email
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\EmailType $item
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function addToEmail(\Sabre\BargainFinderMax\Structs\EmailType $item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\BargainFinderMax\Structs\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AddressType[] $address
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setAddress(array $address = array())
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AddressType $item
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function addToAddress(\Sabre\BargainFinderMax\Structs\AddressType $item)
    {
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\BargainFinderMax\Structs\CustLoyaltyType[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CustLoyaltyType[] $custLoyalty
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CustLoyaltyType $item
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function addToCustLoyalty(\Sabre\BargainFinderMax\Structs\CustLoyaltyType $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \Sabre\BargainFinderMax\Structs\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\DocumentType[] $document
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setDocument(array $document = array())
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\DocumentType $item
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function addToDocument(\Sabre\BargainFinderMax\Structs\DocumentType $item)
    {
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setPassengerTypeQuantity(\Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \Sabre\BargainFinderMax\Structs\TravelerRefNumberType|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param \Sabre\BargainFinderMax\Structs\TravelerRefNumberType $travelerRefNumber
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setTravelerRefNumber(\Sabre\BargainFinderMax\Structs\TravelerRefNumberType $travelerRefNumber = null)
    {
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get FlightSegmentRPHs value
     * @return \Sabre\BargainFinderMax\Structs\FlightSegmentRPHs|null
     */
    public function getFlightSegmentRPHs()
    {
        return $this->FlightSegmentRPHs;
    }
    /**
     * Set FlightSegmentRPHs value
     * @param \Sabre\BargainFinderMax\Structs\FlightSegmentRPHs $flightSegmentRPHs
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setFlightSegmentRPHs(\Sabre\BargainFinderMax\Structs\FlightSegmentRPHs $flightSegmentRPHs = null)
    {
        $this->FlightSegmentRPHs = $flightSegmentRPHs;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get AccompaniedByInfant value
     * @return bool|null
     */
    public function getAccompaniedByInfant()
    {
        return $this->AccompaniedByInfant;
    }
    /**
     * Set AccompaniedByInfant value
     * @param bool $accompaniedByInfant
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setAccompaniedByInfant($accompaniedByInfant = null)
    {
        $this->AccompaniedByInfant = $accompaniedByInfant;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setGender($gender = null)
    {
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
