<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTaxSummaryType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines the data fields available for air tax summary.
 * @subpackage Structs
 */
class AirTaxSummaryType extends AbstractStructBase
{
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the code for the tax. | Used for Character Strings, length 1 to 16
     * - use: required
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $TaxCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The StationCode
     * Meta informations extracted from the WSDL
     * - documentation: Airport code at which the tax or surcharge is being applied
     * @var string
     */
    public $StationCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Tax Country Code | 2 character country code as defined in ISO3166.
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The PublishedAmount
     * @var float
     */
    public $PublishedAmount;
    /**
     * The PublishedCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $PublishedCurrency;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AirTaxSummaryType
     * @uses AirTaxSummaryType::setTaxCode()
     * @uses AirTaxSummaryType::set_()
     * @uses AirTaxSummaryType::setStationCode()
     * @uses AirTaxSummaryType::setCountryCode()
     * @uses AirTaxSummaryType::setPublishedAmount()
     * @uses AirTaxSummaryType::setPublishedCurrency()
     * @uses AirTaxSummaryType::setAmount()
     * @uses AirTaxSummaryType::setCurrencyCode()
     * @uses AirTaxSummaryType::setDecimalPlaces()
     * @param string $taxCode
     * @param string $_
     * @param string $stationCode
     * @param string $countryCode
     * @param float $publishedAmount
     * @param string $publishedCurrency
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($taxCode = null, $_ = null, $stationCode = null, $countryCode = null, $publishedAmount = null, $publishedCurrency = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setTaxCode($taxCode)
            ->set_($_)
            ->setStationCode($stationCode)
            ->setCountryCode($countryCode)
            ->setPublishedAmount($publishedAmount)
            ->setPublishedCurrency($publishedCurrency)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get TaxCode value
     * @return string
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string|null
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setStationCode($stationCode = null)
    {
        $this->StationCode = $stationCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PublishedAmount value
     * @return float|null
     */
    public function getPublishedAmount()
    {
        return $this->PublishedAmount;
    }
    /**
     * Set PublishedAmount value
     * @param float $publishedAmount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setPublishedAmount($publishedAmount = null)
    {
        $this->PublishedAmount = $publishedAmount;
        return $this;
    }
    /**
     * Get PublishedCurrency value
     * @return string|null
     */
    public function getPublishedCurrency()
    {
        return $this->PublishedCurrency;
    }
    /**
     * Set PublishedCurrency value
     * @param string $publishedCurrency
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setPublishedCurrency($publishedCurrency = null)
    {
        $this->PublishedCurrency = $publishedCurrency;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
