<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies the origin and destination of the traveler.
 * @subpackage Structs
 */
class AirItineraryType extends AbstractStructBase
{
    /**
     * The OriginDestinationOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OriginDestinationOptions
     */
    public $OriginDestinationOptions;
    /**
     * The DirectionInd
     * Meta informations extracted from the WSDL
     * - documentation: A directional indicator that identifies a type of air booking (e.g. one-way, round-trip, open-jaw).
     * - use: optional
     * @var string
     */
    public $DirectionInd;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary departure date
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * Constructor method for AirItineraryType
     * @uses AirItineraryType::setOriginDestinationOptions()
     * @uses AirItineraryType::setDirectionInd()
     * @uses AirItineraryType::setDepartureDate()
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions
     * @param string $directionInd
     * @param string $departureDate
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions = null, $directionInd = null, $departureDate = null)
    {
        $this
            ->setOriginDestinationOptions($originDestinationOptions)
            ->setDirectionInd($directionInd)
            ->setDepartureDate($departureDate);
    }
    /**
     * Get OriginDestinationOptions value
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationOptions|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryType
     */
    public function setOriginDestinationOptions(\Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Get DirectionInd value
     * @return string|null
     */
    public function getDirectionInd()
    {
        return $this->DirectionInd;
    }
    /**
     * Set DirectionInd value
     * @uses \Sabre\BargainFinderMax\Enums\AirTripType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\AirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionInd
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryType
     */
    public function setDirectionInd($directionInd = null)
    {
        $this->DirectionInd = $directionInd;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
