<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvReservation Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies constraints on date of advance reservations.
 * @subpackage Structs
 */
class AdvReservation extends AbstractStructBase
{
    /**
     * The LatestTimeOfDay
     * Meta informations extracted from the WSDL
     * - documentation: The time of day by which reservations must be made on the last day that advance reservations can be made. | Allows for the specification of a date time or just time.
     * - use: optional
     * - union: string | time
     * @var string
     */
    public $LatestTimeOfDay;
    /**
     * The LatestPeriod
     * Meta informations extracted from the WSDL
     * - documentation: The amount of elapsed time or number of occurrences of a day of the week before departure needed to satisfy an advance reservation requirement. | Used for Numeric Strings, minimum length 1, maximum length 3.
     * - use: optional
     * - pattern: [0-9]{1,3}
     * @var string
     */
    public $LatestPeriod;
    /**
     * The LatestUnit
     * Meta informations extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the LatestPeriod value.
     * - use: optional
     * @var string
     */
    public $LatestUnit;
    /**
     * Constructor method for AdvReservation
     * @uses AdvReservation::setLatestTimeOfDay()
     * @uses AdvReservation::setLatestPeriod()
     * @uses AdvReservation::setLatestUnit()
     * @param string $latestTimeOfDay
     * @param string $latestPeriod
     * @param string $latestUnit
     */
    public function __construct($latestTimeOfDay = null, $latestPeriod = null, $latestUnit = null)
    {
        $this
            ->setLatestTimeOfDay($latestTimeOfDay)
            ->setLatestPeriod($latestPeriod)
            ->setLatestUnit($latestUnit);
    }
    /**
     * Get LatestTimeOfDay value
     * @return string|null
     */
    public function getLatestTimeOfDay()
    {
        return $this->LatestTimeOfDay;
    }
    /**
     * Set LatestTimeOfDay value
     * @param string $latestTimeOfDay
     * @return \Sabre\BargainFinderMax\Structs\AdvReservation
     */
    public function setLatestTimeOfDay($latestTimeOfDay = null)
    {
        $this->LatestTimeOfDay = $latestTimeOfDay;
        return $this;
    }
    /**
     * Get LatestPeriod value
     * @return string|null
     */
    public function getLatestPeriod()
    {
        return $this->LatestPeriod;
    }
    /**
     * Set LatestPeriod value
     * @param string $latestPeriod
     * @return \Sabre\BargainFinderMax\Structs\AdvReservation
     */
    public function setLatestPeriod($latestPeriod = null)
    {
        $this->LatestPeriod = $latestPeriod;
        return $this;
    }
    /**
     * Get LatestUnit value
     * @return string|null
     */
    public function getLatestUnit()
    {
        return $this->LatestUnit;
    }
    /**
     * Set LatestUnit value
     * @uses \Sabre\BargainFinderMax\Enums\StayUnitType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\StayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $latestUnit
     * @return \Sabre\BargainFinderMax\Structs\AdvReservation
     */
    public function setLatestUnit($latestUnit = null)
    {
        $this->LatestUnit = $latestUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AdvReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
