<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for MessageClassType Enums
 * Meta informations extracted from the WSDL
 * - documentation: Definies the available messaage class type
 * @subpackage Enumerations
 */
class MessageClassType
{
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'W'
     * @return string 'W'
     */
    const VALUE_W = 'W';
    /**
     * Constant for value 'D'
     * @return string 'D'
     */
    const VALUE_D = 'D';
    /**
     * Constant for value 'I'
     * @return string 'I'
     */
    const VALUE_I = 'I';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E
     * @uses self::VALUE_W
     * @uses self::VALUE_D
     * @uses self::VALUE_I
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E,
            self::VALUE_W,
            self::VALUE_D,
            self::VALUE_I,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
