<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for DepartureOrArrival Enums
 * @subpackage Enumerations
 */
class DepartureOrArrival
{
    /**
     * Constant for value 'Departure'
     * @return string 'Departure'
     */
    const VALUE_DEPARTURE = 'Departure';
    /**
     * Constant for value 'Arrival'
     * @return string 'Arrival'
     */
    const VALUE_ARRIVAL = 'Arrival';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEPARTURE
     * @uses self::VALUE_ARRIVAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEPARTURE,
            self::VALUE_ARRIVAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
