<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for BypassAdvancePurchaseType Enums
 * Meta informations extracted from the WSDL
 * - documentation: Controls advance purchase validation logic for repricing. Values 'T'/'F' can be used by AS, for TN the only valid option is 'N'.
 * @subpackage Enumerations
 */
class BypassAdvancePurchaseType
{
    /**
     * Constant for value 'T'
     * @return string 'T'
     */
    const VALUE_T = 'T';
    /**
     * Constant for value 'F'
     * @return string 'F'
     */
    const VALUE_F = 'F';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_T
     * @uses self::VALUE_F
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_T,
            self::VALUE_F,
            self::VALUE_N,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
