<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Weightings Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines how important various parameter options are in the response. Sum of all weightings needs to equal 10.
 * @subpackage Structs
 */
class Weightings extends AbstractStructBase
{
    /**
     * The PriceWeight
     * Meta informations extracted from the WSDL
     * - documentation: Defines how important price options are on a scale from 0 to 10.
     * - use: required
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var int
     */
    public $PriceWeight;
    /**
     * The TravelTimeWeight
     * Meta informations extracted from the WSDL
     * - documentation: Defines how important travel time options are on a scale from 0 to 10.
     * - use: required
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var int
     */
    public $TravelTimeWeight;
    /**
     * Constructor method for Weightings
     * @uses Weightings::setPriceWeight()
     * @uses Weightings::setTravelTimeWeight()
     * @param int $priceWeight
     * @param int $travelTimeWeight
     */
    public function __construct($priceWeight = null, $travelTimeWeight = null)
    {
        $this
            ->setPriceWeight($priceWeight)
            ->setTravelTimeWeight($travelTimeWeight);
    }
    /**
     * Get PriceWeight value
     * @return int
     */
    public function getPriceWeight()
    {
        return $this->PriceWeight;
    }
    /**
     * Set PriceWeight value
     * @param int $priceWeight
     * @return \Sabre\BargainFinderMax\Structs\Weightings
     */
    public function setPriceWeight($priceWeight = null)
    {
        $this->PriceWeight = $priceWeight;
        return $this;
    }
    /**
     * Get TravelTimeWeight value
     * @return int
     */
    public function getTravelTimeWeight()
    {
        return $this->TravelTimeWeight;
    }
    /**
     * Set TravelTimeWeight value
     * @param int $travelTimeWeight
     * @return \Sabre\BargainFinderMax\Structs\Weightings
     */
    public function setTravelTimeWeight($travelTimeWeight = null)
    {
        $this->TravelTimeWeight = $travelTimeWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Weightings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
