<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarningType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Standard way to indicate successful processing of an OTA message, but one in which warnings are generated
 * @subpackage Structs
 */
class WarningType extends FreeTextType
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: The Warning element MUST contain the Type attribute that uses a recommended set of values to indicate the warning type. The validating XSD can expect to accept values that it has NOT been explicitly coded for and process them by
     * using Type ="Unknown". Refer to OTA Code List Error Warning Type (EWT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The _
     * @var \Sabre\BargainFinderMax\Structs\FreeTextType
     */
    public $_;
    /**
     * The ShortText
     * @var string
     */
    public $ShortText;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: If present, this refers to a table of coded values exchanged between applications to identify errors or warnings. Refer to OTA Code List Error Codes (ERR). | Used for codes in the OTA code tables. Possible values of this pattern are
     * 1, 101, 101.EQP, or 101.EQP.X.
     * @var string
     */
    public $Code;
    /**
     * The DocURL
     * Meta informations extracted from the WSDL
     * - documentation: If present, this URL refers to an online description of the error that occurred.
     * @var string
     */
    public $DocURL;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: If present, recommended values are those enumerated in the OTA_ErrorRS, (NotProcessed | Incomplete | Complete | Unknown) however, the data type is designated as string data, recognizing that trading partners may identify additional
     * status conditions not included in the enumeration. | Used for Character Strings, length 1 to 64
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $Status;
    /**
     * The Tag
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
     * tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * @var string
     */
    public $Tag;
    /**
     * The RecordID
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $RecordID;
    /**
     * The MessageClass
     * Meta informations extracted from the WSDL
     * - documentation: If present specify the message class.
     * @var string
     */
    public $MessageClass;
    /**
     * Constructor method for WarningType
     * @uses WarningType::setType()
     * @uses WarningType::set_()
     * @uses WarningType::setShortText()
     * @uses WarningType::setCode()
     * @uses WarningType::setDocURL()
     * @uses WarningType::setStatus()
     * @uses WarningType::setTag()
     * @uses WarningType::setRecordID()
     * @uses WarningType::setMessageClass()
     * @param string $type
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType $_
     * @param string $shortText
     * @param string $code
     * @param string $docURL
     * @param string $status
     * @param string $tag
     * @param string $recordID
     * @param string $messageClass
     */
    public function __construct($type = null, \Sabre\BargainFinderMax\Structs\FreeTextType $_ = null, $shortText = null, $code = null, $docURL = null, $status = null, $tag = null, $recordID = null, $messageClass = null)
    {
        $this
            ->setType($type)
            ->set_($_)
            ->setShortText($shortText)
            ->setCode($code)
            ->setDocURL($docURL)
            ->setStatus($status)
            ->setTag($tag)
            ->setRecordID($recordID)
            ->setMessageClass($messageClass);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return \Sabre\BargainFinderMax\Structs\FreeTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType $_
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function set_(\Sabre\BargainFinderMax\Structs\FreeTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DocURL value
     * @return string|null
     */
    public function getDocURL()
    {
        return $this->DocURL;
    }
    /**
     * Set DocURL value
     * @param string $docURL
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setDocURL($docURL = null)
    {
        $this->DocURL = $docURL;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param string $tag
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setTag($tag = null)
    {
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setRecordID($recordID = null)
    {
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get MessageClass value
     * @return string|null
     */
    public function getMessageClass()
    {
        return $this->MessageClass;
    }
    /**
     * Set MessageClass value
     * @uses \Sabre\BargainFinderMax\Enums\MessageClassType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\MessageClassType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageClass
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public function setMessageClass($messageClass = null)
    {
        $this->MessageClass = $messageClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\WarningType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
