<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPrefApplicabilityType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies if online or interline carrier selection logic should be applied for provided carrier type.
 * @subpackage Structs
 */
class VendorPrefApplicabilityType extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Value;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Specifies what type of carrier it applies to.
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * Constructor method for VendorPrefApplicabilityType
     * @uses VendorPrefApplicabilityType::setValue()
     * @uses VendorPrefApplicabilityType::setType()
     * @param string $value
     * @param string $type
     */
    public function __construct($value = null, $type = null)
    {
        $this
            ->setValue($value)
            ->setType($type);
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Sabre\BargainFinderMax\Enums\CarrierType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\CarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
