<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatingCarrierType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Validating Carrier information
 * @subpackage Structs
 */
class ValidatingCarrierType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Validating Carrier ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The Preference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Preference[]
     */
    public $Preference;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Validating Carrier code
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Code;
    /**
     * The Default
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ValidatingCarrier
     */
    public $Default;
    /**
     * The Alternate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ValidatingCarrier[]
     */
    public $Alternate;
    /**
     * The OtherTicketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ValidatingCarrier[]
     */
    public $OtherTicketing;
    /**
     * The SettlementMethod
     * Meta informations extracted from the WSDL
     * - documentation: Overrides settlement method | Supported codes: BSP ARC TCH GEN (Generic TAT) RUT (Russian TAT) PRT (Philippines TAT) SAT (SATA) KRY (Killroy)
     * - length: 3
     * - pattern: [a-zA-Z0-9]{3}
     * @var string
     */
    public $SettlementMethod;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - documentation: Country code type
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $Country;
    /**
     * The NewVcxProcess
     * @var bool
     */
    public $NewVcxProcess;
    /**
     * Constructor method for ValidatingCarrierType
     * @uses ValidatingCarrierType::setID()
     * @uses ValidatingCarrierType::setPreference()
     * @uses ValidatingCarrierType::setCode()
     * @uses ValidatingCarrierType::setDefault()
     * @uses ValidatingCarrierType::setAlternate()
     * @uses ValidatingCarrierType::setOtherTicketing()
     * @uses ValidatingCarrierType::setSettlementMethod()
     * @uses ValidatingCarrierType::setCountry()
     * @uses ValidatingCarrierType::setNewVcxProcess()
     * @param int $iD
     * @param \Sabre\BargainFinderMax\Structs\Preference[] $preference
     * @param string $code
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier $default
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier[] $alternate
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier[] $otherTicketing
     * @param string $settlementMethod
     * @param string $country
     * @param bool $newVcxProcess
     */
    public function __construct($iD = null, array $preference = array(), $code = null, \Sabre\BargainFinderMax\Structs\ValidatingCarrier $default = null, array $alternate = array(), array $otherTicketing = array(), $settlementMethod = null, $country = null, $newVcxProcess = null)
    {
        $this
            ->setID($iD)
            ->setPreference($preference)
            ->setCode($code)
            ->setDefault($default)
            ->setAlternate($alternate)
            ->setOtherTicketing($otherTicketing)
            ->setSettlementMethod($settlementMethod)
            ->setCountry($country)
            ->setNewVcxProcess($newVcxProcess);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Preference value
     * @return \Sabre\BargainFinderMax\Structs\Preference[]|null
     */
    public function getPreference()
    {
        return $this->Preference;
    }
    /**
     * Set Preference value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Preference[] $preference
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setPreference(array $preference = array())
    {
        $this->Preference = $preference;
        return $this;
    }
    /**
     * Add item to Preference value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Preference $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function addToPreference(\Sabre\BargainFinderMax\Structs\Preference $item)
    {
        $this->Preference[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Default value
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrier|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier $default
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setDefault(\Sabre\BargainFinderMax\Structs\ValidatingCarrier $default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Alternate value
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrier[]|null
     */
    public function getAlternate()
    {
        return $this->Alternate;
    }
    /**
     * Set Alternate value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier[] $alternate
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setAlternate(array $alternate = array())
    {
        $this->Alternate = $alternate;
        return $this;
    }
    /**
     * Add item to Alternate value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function addToAlternate(\Sabre\BargainFinderMax\Structs\ValidatingCarrier $item)
    {
        $this->Alternate[] = $item;
        return $this;
    }
    /**
     * Get OtherTicketing value
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrier[]|null
     */
    public function getOtherTicketing()
    {
        return $this->OtherTicketing;
    }
    /**
     * Set OtherTicketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier[] $otherTicketing
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setOtherTicketing(array $otherTicketing = array())
    {
        $this->OtherTicketing = $otherTicketing;
        return $this;
    }
    /**
     * Add item to OtherTicketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrier $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function addToOtherTicketing(\Sabre\BargainFinderMax\Structs\ValidatingCarrier $item)
    {
        $this->OtherTicketing[] = $item;
        return $this;
    }
    /**
     * Get SettlementMethod value
     * @return string|null
     */
    public function getSettlementMethod()
    {
        return $this->SettlementMethod;
    }
    /**
     * Set SettlementMethod value
     * @param string $settlementMethod
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setSettlementMethod($settlementMethod = null)
    {
        $this->SettlementMethod = $settlementMethod;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setCountry($country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get NewVcxProcess value
     * @return bool|null
     */
    public function getNewVcxProcess()
    {
        return $this->NewVcxProcess;
    }
    /**
     * Set NewVcxProcess value
     * @param bool $newVcxProcess
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public function setNewVcxProcess($newVcxProcess = null)
    {
        $this->NewVcxProcess = $newVcxProcess;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
