<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInformationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies passenger numbers and types.
 * @subpackage Structs
 */
class TravelerInformationType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Specifies number of passengers using Passenger Type Codes.
     * - maxOccurs: 9
     * @var \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[]
     */
    public $PassengerTypeQuantity;
    /**
     * The AirTraveler
     * Meta informations extracted from the WSDL
     * - documentation: Information profiling the person traveling Gender - the gender of the customer, if needed BirthDate - Date of Birth Currency - the preferred currency in which monetary amounts should be returned.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTravelerType
     */
    public $AirTraveler;
    /**
     * Constructor method for TravelerInformationType
     * @uses TravelerInformationType::setPassengerTypeQuantity()
     * @uses TravelerInformationType::setAirTraveler()
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[] $passengerTypeQuantity
     * @param \Sabre\BargainFinderMax\Structs\AirTravelerType $airTraveler
     */
    public function __construct(array $passengerTypeQuantity = array(), \Sabre\BargainFinderMax\Structs\AirTravelerType $airTraveler = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setAirTraveler($airTraveler);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[] $passengerTypeQuantity
     * @return \Sabre\BargainFinderMax\Structs\TravelerInformationType
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $item
     * @return \Sabre\BargainFinderMax\Structs\TravelerInformationType
     */
    public function addToPassengerTypeQuantity(\Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $item)
    {
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get AirTraveler value
     * @return \Sabre\BargainFinderMax\Structs\AirTravelerType|null
     */
    public function getAirTraveler()
    {
        return $this->AirTraveler;
    }
    /**
     * Set AirTraveler value
     * @param \Sabre\BargainFinderMax\Structs\AirTravelerType $airTraveler
     * @return \Sabre\BargainFinderMax\Structs\TravelerInformationType
     */
    public function setAirTraveler(\Sabre\BargainFinderMax\Structs\AirTravelerType $airTraveler = null)
    {
        $this->AirTraveler = $airTraveler;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TravelerInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
