<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoSummaryType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies passenger numbers and types.
 * @subpackage Structs
 */
class TravelerInfoSummaryType extends AbstractStructBase
{
    /**
     * The SeatsRequested
     * Meta informations extracted from the WSDL
     * - documentation: The sum of all seats required by all passenger groups.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var int[]
     */
    public $SeatsRequested;
    /**
     * The AirTravelerAvail
     * Meta informations extracted from the WSDL
     * - documentation: Specifies passenger numbers and types.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TravelerInformationType[]
     */
    public $AirTravelerAvail;
    /**
     * The PriceRequestInformation
     * Meta informations extracted from the WSDL
     * - documentation: Identify pricing source, if negotiated fares are requested and if it is a reprice request.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public $PriceRequestInformation;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - documentation: Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TravelerInfoSummary_TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The SpecificPTC_Indicator
     * Meta informations extracted from the WSDL
     * - documentation: If true, this request is for a specific PTC and only fares applicable to that PTC will be checked and returned. It is the same as XOFares flag in Intellisell request.
     * - use: optional
     * @var bool
     */
    public $SpecificPTC_Indicator;
    /**
     * Constructor method for TravelerInfoSummaryType
     * @uses TravelerInfoSummaryType::setSeatsRequested()
     * @uses TravelerInfoSummaryType::setAirTravelerAvail()
     * @uses TravelerInfoSummaryType::setPriceRequestInformation()
     * @uses TravelerInfoSummaryType::setTPA_Extensions()
     * @uses TravelerInfoSummaryType::setSpecificPTC_Indicator()
     * @param int[] $seatsRequested
     * @param \Sabre\BargainFinderMax\Structs\TravelerInformationType[] $airTravelerAvail
     * @param \Sabre\BargainFinderMax\Structs\PriceRequestInformationType $priceRequestInformation
     * @param \Sabre\BargainFinderMax\Structs\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions
     * @param bool $specificPTC_Indicator
     */
    public function __construct(array $seatsRequested = array(), array $airTravelerAvail = array(), \Sabre\BargainFinderMax\Structs\PriceRequestInformationType $priceRequestInformation = null, \Sabre\BargainFinderMax\Structs\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions = null, $specificPTC_Indicator = null)
    {
        $this
            ->setSeatsRequested($seatsRequested)
            ->setAirTravelerAvail($airTravelerAvail)
            ->setPriceRequestInformation($priceRequestInformation)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSpecificPTC_Indicator($specificPTC_Indicator);
    }
    /**
     * Get SeatsRequested value
     * @return int[]|null
     */
    public function getSeatsRequested()
    {
        return $this->SeatsRequested;
    }
    /**
     * Set SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int[] $seatsRequested
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function setSeatsRequested(array $seatsRequested = array())
    {
        $this->SeatsRequested = $seatsRequested;
        return $this;
    }
    /**
     * Add item to SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function addToSeatsRequested($item)
    {
        $this->SeatsRequested[] = $item;
        return $this;
    }
    /**
     * Get AirTravelerAvail value
     * @return \Sabre\BargainFinderMax\Structs\TravelerInformationType[]|null
     */
    public function getAirTravelerAvail()
    {
        return $this->AirTravelerAvail;
    }
    /**
     * Set AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TravelerInformationType[] $airTravelerAvail
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function setAirTravelerAvail(array $airTravelerAvail = array())
    {
        $this->AirTravelerAvail = $airTravelerAvail;
        return $this;
    }
    /**
     * Add item to AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TravelerInformationType $item
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function addToAirTravelerAvail(\Sabre\BargainFinderMax\Structs\TravelerInformationType $item)
    {
        $this->AirTravelerAvail[] = $item;
        return $this;
    }
    /**
     * Get PriceRequestInformation value
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param \Sabre\BargainFinderMax\Structs\PriceRequestInformationType $priceRequestInformation
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function setPriceRequestInformation(\Sabre\BargainFinderMax\Structs\PriceRequestInformationType $priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummary_TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SpecificPTC_Indicator value
     * @return bool|null
     */
    public function getSpecificPTC_Indicator()
    {
        return $this->SpecificPTC_Indicator;
    }
    /**
     * Set SpecificPTC_Indicator value
     * @param bool $specificPTC_Indicator
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public function setSpecificPTC_Indicator($specificPTC_Indicator = null)
    {
        $this->SpecificPTC_Indicator = $specificPTC_Indicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
