<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDayDistribution Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines how the options in the response should be distributed between certain departure time of day ranges. All defined TimeOfDayRanges need to cover the whole day and the sum of all Percentages needs to equal 100.
 * @subpackage Structs
 */
class TimeOfDayDistribution extends AbstractStructBase
{
    /**
     * The TimeOfDayRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 2
     * @var \Sabre\BargainFinderMax\Structs\TimeOfDayRange[]
     */
    public $TimeOfDayRange;
    /**
     * Constructor method for TimeOfDayDistribution
     * @uses TimeOfDayDistribution::setTimeOfDayRange()
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDayRange[] $timeOfDayRange
     */
    public function __construct(array $timeOfDayRange = array())
    {
        $this
            ->setTimeOfDayRange($timeOfDayRange);
    }
    /**
     * Get TimeOfDayRange value
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayRange[]
     */
    public function getTimeOfDayRange()
    {
        return $this->TimeOfDayRange;
    }
    /**
     * Set TimeOfDayRange value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDayRange[] $timeOfDayRange
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution
     */
    public function setTimeOfDayRange(array $timeOfDayRange = array())
    {
        $this->TimeOfDayRange = $timeOfDayRange;
        return $this;
    }
    /**
     * Add item to TimeOfDayRange value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDayRange $item
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution
     */
    public function addToTimeOfDayRange(\Sabre\BargainFinderMax\Structs\TimeOfDayRange $item)
    {
        $this->TimeOfDayRange[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
