<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketPricingType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Pricing Information for Single Ticket
 * @subpackage Structs
 */
class TicketPricingType extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: Ticket position related to entire itinerary
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The OriginDestinationOptions
     * @var \Sabre\BargainFinderMax\Structs\OriginDestinationOptions
     */
    public $OriginDestinationOptions;
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - documentation: Pricing Information for a Ticket.
     * @var \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta informations extracted from the WSDL
     * - documentation: Container for TicketingInfoRS_Type.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public $TicketingInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * Constructor method for TicketPricingType
     * @uses TicketPricingType::setNumber()
     * @uses TicketPricingType::setOriginDestinationOptions()
     * @uses TicketPricingType::setAirItineraryPricingInfo()
     * @uses TicketPricingType::setNotes()
     * @uses TicketPricingType::setTicketingInfo()
     * @uses TicketPricingType::setTPA_Extensions()
     * @param int $number
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType $airItineraryPricingInfo
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $notes
     * @param \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     */
    public function __construct($number = null, \Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions = null, \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType $airItineraryPricingInfo = null, array $notes = array(), \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this
            ->setNumber($number)
            ->setOriginDestinationOptions($originDestinationOptions)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get OriginDestinationOptions value
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationOptions|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function setOriginDestinationOptions(\Sabre\BargainFinderMax\Structs\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType $airItineraryPricingInfo
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function setAirItineraryPricingInfo(\Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return \Sabre\BargainFinderMax\Structs\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $notes
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function setNotes(array $notes = array())
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType $item
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function addToNotes(\Sabre\BargainFinderMax\Structs\FreeTextType $item)
    {
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function setTicketingInfo(\Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TicketPricingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
