<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Construct for holding a telephone number.
 * @subpackage Structs
 */
class TelephoneType extends AbstractStructBase
{
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PhoneLocationType
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OTA Code List Phone Location Type (PLT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * @var string
     */
    public $PhoneLocationType;
    /**
     * The PhoneTechType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates type of technology associated with this telephone number, such as Voice, Data, Fax, Pager, Mobile, TTY, etc. Refer to OTA Code List Phone Technology Type (PTT). | Used for codes in the OTA code tables. Possible values of
     * this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * @var string
     */
    public $PhoneTechType;
    /**
     * The CountryAccessCode
     * Meta informations extracted from the WSDL
     * - documentation: Code assigned by telecommunications authorities for international country access identifier. | Used for Numeric Strings, minimum length 1, maximum length 3.
     * - pattern: [0-9]{1,3}
     * @var string
     */
    public $CountryAccessCode;
    /**
     * The AreaCityCode
     * Meta informations extracted from the WSDL
     * - documentation: Code assigned for telephones in a specific region, city, or area. | Used for Numeric Strings, length 1 to 8.
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $AreaCityCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Telephone number assigned to a single location. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - documentation: Extension to reach a specific party at the phone number. | Used for Numeric Strings, length 1 to 5
     * - pattern: [0-9]{1,5}
     * @var string
     */
    public $Extension;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - documentation: Additional codes used for pager or telephone access rights. | Used for Character Strings, length 1 to 8
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $PIN;
    /**
     * The FormattedInd
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the associated data is formatted or not. If true, then it is formatted, if false, then not formatted.
     * @var bool
     */
    public $FormattedInd;
    /**
     * Constructor method for TelephoneType
     * @uses TelephoneType::setShareSynchInd()
     * @uses TelephoneType::setShareMarketInd()
     * @uses TelephoneType::setPhoneLocationType()
     * @uses TelephoneType::setPhoneTechType()
     * @uses TelephoneType::setCountryAccessCode()
     * @uses TelephoneType::setAreaCityCode()
     * @uses TelephoneType::setPhoneNumber()
     * @uses TelephoneType::setExtension()
     * @uses TelephoneType::setPIN()
     * @uses TelephoneType::setFormattedInd()
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $phoneLocationType
     * @param string $phoneTechType
     * @param string $countryAccessCode
     * @param string $areaCityCode
     * @param string $phoneNumber
     * @param string $extension
     * @param string $pIN
     * @param bool $formattedInd
     */
    public function __construct($shareSynchInd = null, $shareMarketInd = null, $phoneLocationType = null, $phoneTechType = null, $countryAccessCode = null, $areaCityCode = null, $phoneNumber = null, $extension = null, $pIN = null, $formattedInd = null)
    {
        $this
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPhoneLocationType($phoneLocationType)
            ->setPhoneTechType($phoneTechType)
            ->setCountryAccessCode($countryAccessCode)
            ->setAreaCityCode($areaCityCode)
            ->setPhoneNumber($phoneNumber)
            ->setExtension($extension)
            ->setPIN($pIN)
            ->setFormattedInd($formattedInd);
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PhoneLocationType value
     * @return string|null
     */
    public function getPhoneLocationType()
    {
        return $this->PhoneLocationType;
    }
    /**
     * Set PhoneLocationType value
     * @param string $phoneLocationType
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setPhoneLocationType($phoneLocationType = null)
    {
        $this->PhoneLocationType = $phoneLocationType;
        return $this;
    }
    /**
     * Get PhoneTechType value
     * @return string|null
     */
    public function getPhoneTechType()
    {
        return $this->PhoneTechType;
    }
    /**
     * Set PhoneTechType value
     * @param string $phoneTechType
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setPhoneTechType($phoneTechType = null)
    {
        $this->PhoneTechType = $phoneTechType;
        return $this;
    }
    /**
     * Get CountryAccessCode value
     * @return string|null
     */
    public function getCountryAccessCode()
    {
        return $this->CountryAccessCode;
    }
    /**
     * Set CountryAccessCode value
     * @param string $countryAccessCode
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setCountryAccessCode($countryAccessCode = null)
    {
        $this->CountryAccessCode = $countryAccessCode;
        return $this;
    }
    /**
     * Get AreaCityCode value
     * @return string|null
     */
    public function getAreaCityCode()
    {
        return $this->AreaCityCode;
    }
    /**
     * Set AreaCityCode value
     * @param string $areaCityCode
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setAreaCityCode($areaCityCode = null)
    {
        $this->AreaCityCode = $areaCityCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setExtension($extension = null)
    {
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setPIN($pIN = null)
    {
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public function setFormattedInd($formattedInd = null)
    {
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TelephoneType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
