<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Reissue Tax Type Indicator
 * - length: 1
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Tax ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Tax code | Tax code type | Identifies the code for the tax.
     * - use: required
     * - pattern: [A-Z0-9]{2}[A-Z0-9]{0,1}
     * @var string
     */
    public $Code;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Tax amount
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The TaxReissue
     * Meta informations extracted from the WSDL
     * - documentation: Tax Reissue
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public $TaxReissue;
    /**
     * The TaxRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: Tax Restriction
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxRestrictionsType
     */
    public $TaxRestrictions;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Tax currency code | Currency Code type
     * - use: required | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $Currency;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Tax description
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The PublishedAmount
     * Meta informations extracted from the WSDL
     * - documentation: Published tax amount
     * - use: optional
     * @var float
     */
    public $PublishedAmount;
    /**
     * The PublishedCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Published tax currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $PublishedCurrency;
    /**
     * The Station
     * Meta informations extracted from the WSDL
     * - documentation: Station code - airport code at which the tax or surcharge is being applied. | Airport code type
     * - use: optional | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Station;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - documentation: Country code | Country code type
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $Country;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - documentation: Carrier code for this tax | Airline carrier code type
     * - use: optional
     * - pattern: \*\*
     * @var string
     */
    public $Carrier;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setID()
     * @uses TaxType::setCode()
     * @uses TaxType::setAmount()
     * @uses TaxType::setTaxReissue()
     * @uses TaxType::setTaxRestrictions()
     * @uses TaxType::setCurrency()
     * @uses TaxType::setDescription()
     * @uses TaxType::setPublishedAmount()
     * @uses TaxType::setPublishedCurrency()
     * @uses TaxType::setStation()
     * @uses TaxType::setCountry()
     * @uses TaxType::setCarrier()
     * @param int $iD
     * @param string $code
     * @param float $amount
     * @param \Sabre\BargainFinderMax\Structs\TaxReissueType $taxReissue
     * @param \Sabre\BargainFinderMax\Structs\TaxRestrictionsType $taxRestrictions
     * @param string $currency
     * @param string $description
     * @param float $publishedAmount
     * @param string $publishedCurrency
     * @param string $station
     * @param string $country
     * @param string $carrier
     */
    public function __construct($iD = null, $code = null, $amount = null, \Sabre\BargainFinderMax\Structs\TaxReissueType $taxReissue = null, \Sabre\BargainFinderMax\Structs\TaxRestrictionsType $taxRestrictions = null, $currency = null, $description = null, $publishedAmount = null, $publishedCurrency = null, $station = null, $country = null, $carrier = null)
    {
        $this
            ->setID($iD)
            ->setCode($code)
            ->setAmount($amount)
            ->setTaxReissue($taxReissue)
            ->setTaxRestrictions($taxRestrictions)
            ->setCurrency($currency)
            ->setDescription($description)
            ->setPublishedAmount($publishedAmount)
            ->setPublishedCurrency($publishedCurrency)
            ->setStation($station)
            ->setCountry($country)
            ->setCarrier($carrier);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxReissue value
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType|null
     */
    public function getTaxReissue()
    {
        return $this->TaxReissue;
    }
    /**
     * Set TaxReissue value
     * @param \Sabre\BargainFinderMax\Structs\TaxReissueType $taxReissue
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setTaxReissue(\Sabre\BargainFinderMax\Structs\TaxReissueType $taxReissue = null)
    {
        $this->TaxReissue = $taxReissue;
        return $this;
    }
    /**
     * Get TaxRestrictions value
     * @return \Sabre\BargainFinderMax\Structs\TaxRestrictionsType|null
     */
    public function getTaxRestrictions()
    {
        return $this->TaxRestrictions;
    }
    /**
     * Set TaxRestrictions value
     * @param \Sabre\BargainFinderMax\Structs\TaxRestrictionsType $taxRestrictions
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setTaxRestrictions(\Sabre\BargainFinderMax\Structs\TaxRestrictionsType $taxRestrictions = null)
    {
        $this->TaxRestrictions = $taxRestrictions;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PublishedAmount value
     * @return float|null
     */
    public function getPublishedAmount()
    {
        return $this->PublishedAmount;
    }
    /**
     * Set PublishedAmount value
     * @param float $publishedAmount
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setPublishedAmount($publishedAmount = null)
    {
        $this->PublishedAmount = $publishedAmount;
        return $this;
    }
    /**
     * Get PublishedCurrency value
     * @return string|null
     */
    public function getPublishedCurrency()
    {
        return $this->PublishedCurrency;
    }
    /**
     * Set PublishedCurrency value
     * @param string $publishedCurrency
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setPublishedCurrency($publishedCurrency = null)
    {
        $this->PublishedCurrency = $publishedCurrency;
        return $this;
    }
    /**
     * Get Station value
     * @return string|null
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * Set Station value
     * @param string $station
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setStation($station = null)
    {
        $this->Station = $station;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setCountry($country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
