<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoldOutType Structs
 * @subpackage Structs
 */
class SoldOutType extends AbstractStructBase
{
    /**
     * The SoldOutLeg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SoldOutLegType[]
     */
    public $SoldOutLeg;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for SoldOutType
     * @uses SoldOutType::setSoldOutLeg()
     * @uses SoldOutType::setStatus()
     * @param \Sabre\BargainFinderMax\Structs\SoldOutLegType[] $soldOutLeg
     * @param string $status
     */
    public function __construct(array $soldOutLeg = array(), $status = null)
    {
        $this
            ->setSoldOutLeg($soldOutLeg)
            ->setStatus($status);
    }
    /**
     * Get SoldOutLeg value
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType[]|null
     */
    public function getSoldOutLeg()
    {
        return $this->SoldOutLeg;
    }
    /**
     * Set SoldOutLeg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SoldOutLegType[] $soldOutLeg
     * @return \Sabre\BargainFinderMax\Structs\SoldOutType
     */
    public function setSoldOutLeg(array $soldOutLeg = array())
    {
        $this->SoldOutLeg = $soldOutLeg;
        return $this;
    }
    /**
     * Add item to SoldOutLeg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SoldOutLegType $item
     * @return \Sabre\BargainFinderMax\Structs\SoldOutType
     */
    public function addToSoldOutLeg(\Sabre\BargainFinderMax\Structs\SoldOutLegType $item)
    {
        $this->SoldOutLeg[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\BargainFinderMax\Structs\SoldOutType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SoldOutType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
