<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShowFareAmounts Structs
 * @subpackage Structs
 */
class ShowFareAmounts extends AbstractStructBase
{
    /**
     * The Original
     * Meta informations extracted from the WSDL
     * - documentation: Show original selling fare level amounts and total adjusted amount in Fare Calc line
     * - use: optional
     * @var bool
     */
    public $Original;
    /**
     * The Adjusted
     * Meta informations extracted from the WSDL
     * - documentation: Show selling level amounts and total adjusted amount in Fare Calc line
     * - use: optional
     * @var bool
     */
    public $Adjusted;
    /**
     * Constructor method for ShowFareAmounts
     * @uses ShowFareAmounts::setOriginal()
     * @uses ShowFareAmounts::setAdjusted()
     * @param bool $original
     * @param bool $adjusted
     */
    public function __construct($original = null, $adjusted = null)
    {
        $this
            ->setOriginal($original)
            ->setAdjusted($adjusted);
    }
    /**
     * Get Original value
     * @return bool|null
     */
    public function getOriginal()
    {
        return $this->Original;
    }
    /**
     * Set Original value
     * @param bool $original
     * @return \Sabre\BargainFinderMax\Structs\ShowFareAmounts
     */
    public function setOriginal($original = null)
    {
        $this->Original = $original;
        return $this;
    }
    /**
     * Get Adjusted value
     * @return bool|null
     */
    public function getAdjusted()
    {
        return $this->Adjusted;
    }
    /**
     * Set Adjusted value
     * @param bool $adjusted
     * @return \Sabre\BargainFinderMax\Structs\ShowFareAmounts
     */
    public function setAdjusted($adjusted = null)
    {
        $this->Adjusted = $adjusted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ShowFareAmounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
