<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellingFareDataType Structs
 * @subpackage Structs
 */
class SellingFareDataType extends AbstractStructBase
{
    /**
     * The LayerTypeName
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LayerTypeName;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Layer Type Name
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The HandlingMarkupSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType[]
     */
    public $HandlingMarkupSummary;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - documentation: Any individual tax applied to the fare
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTaxType[]
     */
    public $Tax;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - documentation: Tax Summary Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The BaseFareAmount
     * Meta informations extracted from the WSDL
     * - documentation: Base fare amount (in base fare currency)
     * - use: optional
     * @var float
     */
    public $BaseFareAmount;
    /**
     * The ConstructedTotalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Constructed total amount
     * - use: optional
     * @var float
     */
    public $ConstructedTotalAmount;
    /**
     * The EquivalentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Equivalent amount ( in equivalent currency)
     * - use: optional
     * @var float
     */
    public $EquivalentAmount;
    /**
     * The TotalTaxes
     * Meta informations extracted from the WSDL
     * - documentation: Total taxes (in equivalent currency)
     * - use: optional
     * @var float
     */
    public $TotalTaxes;
    /**
     * The TotalPerPassenger
     * Meta informations extracted from the WSDL
     * - documentation: Total per passenger
     * - use: optional
     * @var float
     */
    public $TotalPerPassenger;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - documentation: Fare calculation
     * - use: optional
     * @var string
     */
    public $FareCalculation;
    /**
     * The HandlingMarkup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\HandlingMarkupType[]
     */
    public $HandlingMarkup;
    /**
     * Constructor method for SellingFareDataType
     * @uses SellingFareDataType::setLayerTypeName()
     * @uses SellingFareDataType::setType()
     * @uses SellingFareDataType::setHandlingMarkupSummary()
     * @uses SellingFareDataType::setTax()
     * @uses SellingFareDataType::setTaxSummary()
     * @uses SellingFareDataType::setBaseFareAmount()
     * @uses SellingFareDataType::setConstructedTotalAmount()
     * @uses SellingFareDataType::setEquivalentAmount()
     * @uses SellingFareDataType::setTotalTaxes()
     * @uses SellingFareDataType::setTotalPerPassenger()
     * @uses SellingFareDataType::setFareCalculation()
     * @uses SellingFareDataType::setHandlingMarkup()
     * @param string $layerTypeName
     * @param string $type
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType[] $handlingMarkupSummary
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType[] $tax
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @param float $baseFareAmount
     * @param float $constructedTotalAmount
     * @param float $equivalentAmount
     * @param float $totalTaxes
     * @param float $totalPerPassenger
     * @param string $fareCalculation
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupType[] $handlingMarkup
     */
    public function __construct($layerTypeName = null, $type = null, array $handlingMarkupSummary = array(), array $tax = array(), array $taxSummary = array(), $baseFareAmount = null, $constructedTotalAmount = null, $equivalentAmount = null, $totalTaxes = null, $totalPerPassenger = null, $fareCalculation = null, array $handlingMarkup = array())
    {
        $this
            ->setLayerTypeName($layerTypeName)
            ->setType($type)
            ->setHandlingMarkupSummary($handlingMarkupSummary)
            ->setTax($tax)
            ->setTaxSummary($taxSummary)
            ->setBaseFareAmount($baseFareAmount)
            ->setConstructedTotalAmount($constructedTotalAmount)
            ->setEquivalentAmount($equivalentAmount)
            ->setTotalTaxes($totalTaxes)
            ->setTotalPerPassenger($totalPerPassenger)
            ->setFareCalculation($fareCalculation)
            ->setHandlingMarkup($handlingMarkup);
    }
    /**
     * Get LayerTypeName value
     * @return string
     */
    public function getLayerTypeName()
    {
        return $this->LayerTypeName;
    }
    /**
     * Set LayerTypeName value
     * @param string $layerTypeName
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setLayerTypeName($layerTypeName = null)
    {
        $this->LayerTypeName = $layerTypeName;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get HandlingMarkupSummary value
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType[]|null
     */
    public function getHandlingMarkupSummary()
    {
        return $this->HandlingMarkupSummary;
    }
    /**
     * Set HandlingMarkupSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType[] $handlingMarkupSummary
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setHandlingMarkupSummary(array $handlingMarkupSummary = array())
    {
        $this->HandlingMarkupSummary = $handlingMarkupSummary;
        return $this;
    }
    /**
     * Add item to HandlingMarkupSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType $item
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function addToHandlingMarkupSummary(\Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType $item)
    {
        $this->HandlingMarkupSummary[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType[] $tax
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType $item
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function addToTax(\Sabre\BargainFinderMax\Structs\AirTaxType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get BaseFareAmount value
     * @return float|null
     */
    public function getBaseFareAmount()
    {
        return $this->BaseFareAmount;
    }
    /**
     * Set BaseFareAmount value
     * @param float $baseFareAmount
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setBaseFareAmount($baseFareAmount = null)
    {
        $this->BaseFareAmount = $baseFareAmount;
        return $this;
    }
    /**
     * Get ConstructedTotalAmount value
     * @return float|null
     */
    public function getConstructedTotalAmount()
    {
        return $this->ConstructedTotalAmount;
    }
    /**
     * Set ConstructedTotalAmount value
     * @param float $constructedTotalAmount
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setConstructedTotalAmount($constructedTotalAmount = null)
    {
        $this->ConstructedTotalAmount = $constructedTotalAmount;
        return $this;
    }
    /**
     * Get EquivalentAmount value
     * @return float|null
     */
    public function getEquivalentAmount()
    {
        return $this->EquivalentAmount;
    }
    /**
     * Set EquivalentAmount value
     * @param float $equivalentAmount
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setEquivalentAmount($equivalentAmount = null)
    {
        $this->EquivalentAmount = $equivalentAmount;
        return $this;
    }
    /**
     * Get TotalTaxes value
     * @return float|null
     */
    public function getTotalTaxes()
    {
        return $this->TotalTaxes;
    }
    /**
     * Set TotalTaxes value
     * @param float $totalTaxes
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setTotalTaxes($totalTaxes = null)
    {
        $this->TotalTaxes = $totalTaxes;
        return $this;
    }
    /**
     * Get TotalPerPassenger value
     * @return float|null
     */
    public function getTotalPerPassenger()
    {
        return $this->TotalPerPassenger;
    }
    /**
     * Set TotalPerPassenger value
     * @param float $totalPerPassenger
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setTotalPerPassenger($totalPerPassenger = null)
    {
        $this->TotalPerPassenger = $totalPerPassenger;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return string|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param string $fareCalculation
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setFareCalculation($fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get HandlingMarkup value
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupType[]|null
     */
    public function getHandlingMarkup()
    {
        return $this->HandlingMarkup;
    }
    /**
     * Set HandlingMarkup value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupType[] $handlingMarkup
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function setHandlingMarkup(array $handlingMarkup = array())
    {
        $this->HandlingMarkup = $handlingMarkup;
        return $this;
    }
    /**
     * Add item to HandlingMarkup value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupType $item
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public function addToHandlingMarkup(\Sabre\BargainFinderMax\Structs\HandlingMarkupType $item)
    {
        $this->HandlingMarkup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
