<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleDescType Structs
 * @subpackage Structs
 */
class ScheduleDescType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Schedule ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The Departure
     * @var \Sabre\BargainFinderMax\Structs\Departure
     */
    public $Departure;
    /**
     * The Arrival
     * @var \Sabre\BargainFinderMax\Structs\Arrival
     */
    public $Arrival;
    /**
     * The Carrier
     * @var \Sabre\BargainFinderMax\Structs\Carrier
     */
    public $Carrier;
    /**
     * The HiddenStop
     * Meta informations extracted from the WSDL
     * - documentation: Intermediate Point Info
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\HiddenStopType[]
     */
    public $HiddenStop;
    /**
     * The BookingDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BookingDetails
     */
    public $BookingDetails;
    /**
     * The DotRating
     * @var string
     */
    public $DotRating;
    /**
     * The OnTimePerformance
     * @var string
     */
    public $OnTimePerformance;
    /**
     * The TrafficRestriction
     * @var string
     */
    public $TrafficRestriction;
    /**
     * The Frequency
     * @var string
     */
    public $Frequency;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Is Smoking Allowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The Funnel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Funnel Flight
     * @var bool
     */
    public $Funnel;
    /**
     * The Stops
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Number Of Stops
     * @var int
     */
    public $Stops;
    /**
     * The FlightStatused
     * Meta informations extracted from the WSDL
     * - documentation: Flight Statused
     * @var string
     */
    public $FlightStatused;
    /**
     * The GovernmentApproval
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Segment to government Approval
     * @var bool
     */
    public $GovernmentApproval;
    /**
     * The ETicketable
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Is eTicketable
     * @var bool
     */
    public $ETicketable;
    /**
     * The TotalMilesFlown
     * Meta informations extracted from the WSDL
     * - documentation: Total Air Miles Flown
     * @var int
     */
    public $TotalMilesFlown;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Message
     * @var string
     */
    public $Message;
    /**
     * The MessageType
     * Meta informations extracted from the WSDL
     * - documentation: Message Type
     * @var string
     */
    public $MessageType;
    /**
     * Constructor method for ScheduleDescType
     * @uses ScheduleDescType::setID()
     * @uses ScheduleDescType::setDeparture()
     * @uses ScheduleDescType::setArrival()
     * @uses ScheduleDescType::setCarrier()
     * @uses ScheduleDescType::setHiddenStop()
     * @uses ScheduleDescType::setBookingDetails()
     * @uses ScheduleDescType::setDotRating()
     * @uses ScheduleDescType::setOnTimePerformance()
     * @uses ScheduleDescType::setTrafficRestriction()
     * @uses ScheduleDescType::setFrequency()
     * @uses ScheduleDescType::setSmokingAllowed()
     * @uses ScheduleDescType::setFunnel()
     * @uses ScheduleDescType::setStops()
     * @uses ScheduleDescType::setFlightStatused()
     * @uses ScheduleDescType::setGovernmentApproval()
     * @uses ScheduleDescType::setETicketable()
     * @uses ScheduleDescType::setTotalMilesFlown()
     * @uses ScheduleDescType::setMessage()
     * @uses ScheduleDescType::setMessageType()
     * @param int $iD
     * @param \Sabre\BargainFinderMax\Structs\Departure $departure
     * @param \Sabre\BargainFinderMax\Structs\Arrival $arrival
     * @param \Sabre\BargainFinderMax\Structs\Carrier $carrier
     * @param \Sabre\BargainFinderMax\Structs\HiddenStopType[] $hiddenStop
     * @param \Sabre\BargainFinderMax\Structs\BookingDetails $bookingDetails
     * @param string $dotRating
     * @param string $onTimePerformance
     * @param string $trafficRestriction
     * @param string $frequency
     * @param bool $smokingAllowed
     * @param bool $funnel
     * @param int $stops
     * @param string $flightStatused
     * @param bool $governmentApproval
     * @param bool $eTicketable
     * @param int $totalMilesFlown
     * @param string $message
     * @param string $messageType
     */
    public function __construct($iD = null, \Sabre\BargainFinderMax\Structs\Departure $departure = null, \Sabre\BargainFinderMax\Structs\Arrival $arrival = null, \Sabre\BargainFinderMax\Structs\Carrier $carrier = null, array $hiddenStop = array(), \Sabre\BargainFinderMax\Structs\BookingDetails $bookingDetails = null, $dotRating = null, $onTimePerformance = null, $trafficRestriction = null, $frequency = null, $smokingAllowed = false, $funnel = false, $stops = '0', $flightStatused = null, $governmentApproval = false, $eTicketable = false, $totalMilesFlown = null, $message = null, $messageType = null)
    {
        $this
            ->setID($iD)
            ->setDeparture($departure)
            ->setArrival($arrival)
            ->setCarrier($carrier)
            ->setHiddenStop($hiddenStop)
            ->setBookingDetails($bookingDetails)
            ->setDotRating($dotRating)
            ->setOnTimePerformance($onTimePerformance)
            ->setTrafficRestriction($trafficRestriction)
            ->setFrequency($frequency)
            ->setSmokingAllowed($smokingAllowed)
            ->setFunnel($funnel)
            ->setStops($stops)
            ->setFlightStatused($flightStatused)
            ->setGovernmentApproval($governmentApproval)
            ->setETicketable($eTicketable)
            ->setTotalMilesFlown($totalMilesFlown)
            ->setMessage($message)
            ->setMessageType($messageType);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Departure value
     * @return \Sabre\BargainFinderMax\Structs\Departure|null
     */
    public function getDeparture()
    {
        return $this->Departure;
    }
    /**
     * Set Departure value
     * @param \Sabre\BargainFinderMax\Structs\Departure $departure
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setDeparture(\Sabre\BargainFinderMax\Structs\Departure $departure = null)
    {
        $this->Departure = $departure;
        return $this;
    }
    /**
     * Get Arrival value
     * @return \Sabre\BargainFinderMax\Structs\Arrival|null
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \Sabre\BargainFinderMax\Structs\Arrival $arrival
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setArrival(\Sabre\BargainFinderMax\Structs\Arrival $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \Sabre\BargainFinderMax\Structs\Carrier|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \Sabre\BargainFinderMax\Structs\Carrier $carrier
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setCarrier(\Sabre\BargainFinderMax\Structs\Carrier $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get HiddenStop value
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType[]|null
     */
    public function getHiddenStop()
    {
        return $this->HiddenStop;
    }
    /**
     * Set HiddenStop value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HiddenStopType[] $hiddenStop
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setHiddenStop(array $hiddenStop = array())
    {
        $this->HiddenStop = $hiddenStop;
        return $this;
    }
    /**
     * Add item to HiddenStop value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HiddenStopType $item
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function addToHiddenStop(\Sabre\BargainFinderMax\Structs\HiddenStopType $item)
    {
        $this->HiddenStop[] = $item;
        return $this;
    }
    /**
     * Get BookingDetails value
     * @return \Sabre\BargainFinderMax\Structs\BookingDetails|null
     */
    public function getBookingDetails()
    {
        return $this->BookingDetails;
    }
    /**
     * Set BookingDetails value
     * @param \Sabre\BargainFinderMax\Structs\BookingDetails $bookingDetails
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setBookingDetails(\Sabre\BargainFinderMax\Structs\BookingDetails $bookingDetails = null)
    {
        $this->BookingDetails = $bookingDetails;
        return $this;
    }
    /**
     * Get DotRating value
     * @return string|null
     */
    public function getDotRating()
    {
        return $this->DotRating;
    }
    /**
     * Set DotRating value
     * @param string $dotRating
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setDotRating($dotRating = null)
    {
        $this->DotRating = $dotRating;
        return $this;
    }
    /**
     * Get OnTimePerformance value
     * @return string|null
     */
    public function getOnTimePerformance()
    {
        return $this->OnTimePerformance;
    }
    /**
     * Set OnTimePerformance value
     * @param string $onTimePerformance
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setOnTimePerformance($onTimePerformance = null)
    {
        $this->OnTimePerformance = $onTimePerformance;
        return $this;
    }
    /**
     * Get TrafficRestriction value
     * @return string|null
     */
    public function getTrafficRestriction()
    {
        return $this->TrafficRestriction;
    }
    /**
     * Set TrafficRestriction value
     * @param string $trafficRestriction
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setTrafficRestriction($trafficRestriction = null)
    {
        $this->TrafficRestriction = $trafficRestriction;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setFrequency($frequency = null)
    {
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get Funnel value
     * @return bool|null
     */
    public function getFunnel()
    {
        return $this->Funnel;
    }
    /**
     * Set Funnel value
     * @param bool $funnel
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setFunnel($funnel = false)
    {
        $this->Funnel = $funnel;
        return $this;
    }
    /**
     * Get Stops value
     * @return int|null
     */
    public function getStops()
    {
        return $this->Stops;
    }
    /**
     * Set Stops value
     * @param int $stops
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setStops($stops = '0')
    {
        $this->Stops = $stops;
        return $this;
    }
    /**
     * Get FlightStatused value
     * @return string|null
     */
    public function getFlightStatused()
    {
        return $this->FlightStatused;
    }
    /**
     * Set FlightStatused value
     * @param string $flightStatused
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setFlightStatused($flightStatused = null)
    {
        $this->FlightStatused = $flightStatused;
        return $this;
    }
    /**
     * Get GovernmentApproval value
     * @return bool|null
     */
    public function getGovernmentApproval()
    {
        return $this->GovernmentApproval;
    }
    /**
     * Set GovernmentApproval value
     * @param bool $governmentApproval
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setGovernmentApproval($governmentApproval = false)
    {
        $this->GovernmentApproval = $governmentApproval;
        return $this;
    }
    /**
     * Get ETicketable value
     * @return bool|null
     */
    public function getETicketable()
    {
        return $this->ETicketable;
    }
    /**
     * Set ETicketable value
     * @param bool $eTicketable
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setETicketable($eTicketable = false)
    {
        $this->ETicketable = $eTicketable;
        return $this;
    }
    /**
     * Get TotalMilesFlown value
     * @return int|null
     */
    public function getTotalMilesFlown()
    {
        return $this->TotalMilesFlown;
    }
    /**
     * Set TotalMilesFlown value
     * @param int $totalMilesFlown
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setTotalMilesFlown($totalMilesFlown = null)
    {
        $this->TotalMilesFlown = $totalMilesFlown;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get MessageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param string $messageType
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public function setMessageType($messageType = null)
    {
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
