<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutingDefinitionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Definition of a routing
 * @subpackage Structs
 */
class RoutingDefinitionType extends AbstractStructBase
{
    /**
     * The RoutingLeg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\RoutingLegType[]
     */
    public $RoutingLeg;
    /**
     * The AddWildcards
     * Meta informations extracted from the WSDL
     * - documentation: If true, wildcards will be automatically inserted between each two leg (RoutingLeg) elements. Will be set to 'false' if not present.
     * - use: optional
     * @var bool
     */
    public $AddWildcards;
    /**
     * Constructor method for RoutingDefinitionType
     * @uses RoutingDefinitionType::setRoutingLeg()
     * @uses RoutingDefinitionType::setAddWildcards()
     * @param \Sabre\BargainFinderMax\Structs\RoutingLegType[] $routingLeg
     * @param bool $addWildcards
     */
    public function __construct(array $routingLeg = array(), $addWildcards = null)
    {
        $this
            ->setRoutingLeg($routingLeg)
            ->setAddWildcards($addWildcards);
    }
    /**
     * Get RoutingLeg value
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType[]|null
     */
    public function getRoutingLeg()
    {
        return $this->RoutingLeg;
    }
    /**
     * Set RoutingLeg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\RoutingLegType[] $routingLeg
     * @return \Sabre\BargainFinderMax\Structs\RoutingDefinitionType
     */
    public function setRoutingLeg(array $routingLeg = array())
    {
        $this->RoutingLeg = $routingLeg;
        return $this;
    }
    /**
     * Add item to RoutingLeg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\RoutingLegType $item
     * @return \Sabre\BargainFinderMax\Structs\RoutingDefinitionType
     */
    public function addToRoutingLeg(\Sabre\BargainFinderMax\Structs\RoutingLegType $item)
    {
        $this->RoutingLeg[] = $item;
        return $this;
    }
    /**
     * Get AddWildcards value
     * @return bool|null
     */
    public function getAddWildcards()
    {
        return $this->AddWildcards;
    }
    /**
     * Set AddWildcards value
     * @param bool $addWildcards
     * @return \Sabre\BargainFinderMax\Structs\RoutingDefinitionType
     */
    public function setAddWildcards($addWildcards = null)
    {
        $this->AddWildcards = $addWildcards;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\RoutingDefinitionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
