<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseLocationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Code and optional string to describe a location point.
 * @subpackage Structs
 */
class ResponseLocationType extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: Location identifying code. | Used for Character Strings, length 1 to 8
     * - use: required
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $LocationCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - default: IATA
     * - documentation: Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for ResponseLocationType
     * @uses ResponseLocationType::setLocationCode()
     * @uses ResponseLocationType::set_()
     * @uses ResponseLocationType::setCodeContext()
     * @param string $locationCode
     * @param string $_
     * @param string $codeContext
     */
    public function __construct($locationCode = null, $_ = null, $codeContext = 'IATA')
    {
        $this
            ->setLocationCode($locationCode)
            ->set_($_)
            ->setCodeContext($codeContext);
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public function setCodeContext($codeContext = 'IATA')
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
