<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestLocationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Code and optional string to describe a location point.
 * @subpackage Structs
 */
class RequestLocationType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The AirportsGroup
     * @var string
     */
    public $AirportsGroup;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - default: IATA
     * - documentation: Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for RequestLocationType
     * @uses RequestLocationType::set_()
     * @uses RequestLocationType::setLocationCode()
     * @uses RequestLocationType::setAirportsGroup()
     * @uses RequestLocationType::setCodeContext()
     * @param string $_
     * @param string $locationCode
     * @param string $airportsGroup
     * @param string $codeContext
     */
    public function __construct($_ = null, $locationCode = null, $airportsGroup = null, $codeContext = 'IATA')
    {
        $this
            ->set_($_)
            ->setLocationCode($locationCode)
            ->setAirportsGroup($airportsGroup)
            ->setCodeContext($codeContext);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get AirportsGroup value
     * @return string|null
     */
    public function getAirportsGroup()
    {
        return $this->AirportsGroup;
    }
    /**
     * Set AirportsGroup value
     * @param string $airportsGroup
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public function setAirportsGroup($airportsGroup = null)
    {
        $this->AirportsGroup = $airportsGroup;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public function setCodeContext($codeContext = 'IATA')
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
