<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Priority Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element governs how flights are returned. A user can uses a priority of 1-9 to make this determination.
 * @subpackage Structs
 */
class Priority extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Price
     */
    public $Price;
    /**
     * The DirectFlights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DirectFlights
     */
    public $DirectFlights;
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Time
     */
    public $Time;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Vendor
     */
    public $Vendor;
    /**
     * The MarketingCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\MarketingCarrier
     */
    public $MarketingCarrier;
    /**
     * The OperatingCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OperatingCarrier
     */
    public $OperatingCarrier;
    /**
     * The ElapsedTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ElapsedTime
     */
    public $ElapsedTime;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DepartureTime
     */
    public $DepartureTime;
    /**
     * The ConnectionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public $ConnectionTime;
    /**
     * Constructor method for Priority
     * @uses Priority::setPrice()
     * @uses Priority::setDirectFlights()
     * @uses Priority::setTime()
     * @uses Priority::setVendor()
     * @uses Priority::setMarketingCarrier()
     * @uses Priority::setOperatingCarrier()
     * @uses Priority::setElapsedTime()
     * @uses Priority::setDepartureTime()
     * @uses Priority::setConnectionTime()
     * @param \Sabre\BargainFinderMax\Structs\Price $price
     * @param \Sabre\BargainFinderMax\Structs\DirectFlights $directFlights
     * @param \Sabre\BargainFinderMax\Structs\Time $time
     * @param \Sabre\BargainFinderMax\Structs\Vendor $vendor
     * @param \Sabre\BargainFinderMax\Structs\MarketingCarrier $marketingCarrier
     * @param \Sabre\BargainFinderMax\Structs\OperatingCarrier $operatingCarrier
     * @param \Sabre\BargainFinderMax\Structs\ElapsedTime $elapsedTime
     * @param \Sabre\BargainFinderMax\Structs\DepartureTime $departureTime
     * @param \Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\Price $price = null, \Sabre\BargainFinderMax\Structs\DirectFlights $directFlights = null, \Sabre\BargainFinderMax\Structs\Time $time = null, \Sabre\BargainFinderMax\Structs\Vendor $vendor = null, \Sabre\BargainFinderMax\Structs\MarketingCarrier $marketingCarrier = null, \Sabre\BargainFinderMax\Structs\OperatingCarrier $operatingCarrier = null, \Sabre\BargainFinderMax\Structs\ElapsedTime $elapsedTime = null, \Sabre\BargainFinderMax\Structs\DepartureTime $departureTime = null, \Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime = null)
    {
        $this
            ->setPrice($price)
            ->setDirectFlights($directFlights)
            ->setTime($time)
            ->setVendor($vendor)
            ->setMarketingCarrier($marketingCarrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setElapsedTime($elapsedTime)
            ->setDepartureTime($departureTime)
            ->setConnectionTime($connectionTime);
    }
    /**
     * Get Price value
     * @return \Sabre\BargainFinderMax\Structs\Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Sabre\BargainFinderMax\Structs\Price $price
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setPrice(\Sabre\BargainFinderMax\Structs\Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get DirectFlights value
     * @return \Sabre\BargainFinderMax\Structs\DirectFlights|null
     */
    public function getDirectFlights()
    {
        return $this->DirectFlights;
    }
    /**
     * Set DirectFlights value
     * @param \Sabre\BargainFinderMax\Structs\DirectFlights $directFlights
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setDirectFlights(\Sabre\BargainFinderMax\Structs\DirectFlights $directFlights = null)
    {
        $this->DirectFlights = $directFlights;
        return $this;
    }
    /**
     * Get Time value
     * @return \Sabre\BargainFinderMax\Structs\Time|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param \Sabre\BargainFinderMax\Structs\Time $time
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setTime(\Sabre\BargainFinderMax\Structs\Time $time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\BargainFinderMax\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\BargainFinderMax\Structs\Vendor $vendor
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setVendor(\Sabre\BargainFinderMax\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return \Sabre\BargainFinderMax\Structs\MarketingCarrier|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param \Sabre\BargainFinderMax\Structs\MarketingCarrier $marketingCarrier
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setMarketingCarrier(\Sabre\BargainFinderMax\Structs\MarketingCarrier $marketingCarrier = null)
    {
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return \Sabre\BargainFinderMax\Structs\OperatingCarrier|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param \Sabre\BargainFinderMax\Structs\OperatingCarrier $operatingCarrier
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setOperatingCarrier(\Sabre\BargainFinderMax\Structs\OperatingCarrier $operatingCarrier = null)
    {
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return \Sabre\BargainFinderMax\Structs\ElapsedTime|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param \Sabre\BargainFinderMax\Structs\ElapsedTime $elapsedTime
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setElapsedTime(\Sabre\BargainFinderMax\Structs\ElapsedTime $elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return \Sabre\BargainFinderMax\Structs\DepartureTime|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param \Sabre\BargainFinderMax\Structs\DepartureTime $departureTime
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setDepartureTime(\Sabre\BargainFinderMax\Structs\DepartureTime $departureTime = null)
    {
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get ConnectionTime value
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime|null
     */
    public function getConnectionTime()
    {
        return $this->ConnectionTime;
    }
    /**
     * Set ConnectionTime value
     * @param \Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public function setConnectionTime(\Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime = null)
    {
        $this->ConnectionTime = $connectionTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Priority
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
