<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingLegType Structs
 * @subpackage Structs
 */
class PricingLegType extends AbstractStructBase
{
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - documentation: Reference to LegDescription ID
     * - use: required
     * @var int
     */
    public $Ref;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxIDType[]
     */
    public $Tax;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[]
     */
    public $TaxSummary;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public $TotalFare;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for PricingLegType
     * @uses PricingLegType::setRef()
     * @uses PricingLegType::setTax()
     * @uses PricingLegType::setTaxSummary()
     * @uses PricingLegType::setTotalFare()
     * @uses PricingLegType::setStatus()
     * @param int $ref
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType[] $tax
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[] $taxSummary
     * @param \Sabre\BargainFinderMax\Structs\TotalFareType $totalFare
     * @param string $status
     */
    public function __construct($ref = null, array $tax = array(), array $taxSummary = array(), \Sabre\BargainFinderMax\Structs\TotalFareType $totalFare = null, $status = null)
    {
        $this
            ->setRef($ref)
            ->setTax($tax)
            ->setTaxSummary($taxSummary)
            ->setTotalFare($totalFare)
            ->setStatus($status);
    }
    /**
     * Get Ref value
     * @return int
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param int $ref
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function setRef($ref = null)
    {
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\TaxIDType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType[] $tax
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType $item
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function addToTax(\Sabre\BargainFinderMax\Structs\TaxIDType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType $item
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\TaxSummaryIDType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \Sabre\BargainFinderMax\Structs\TotalFareType $totalFare
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function setTotalFare(\Sabre\BargainFinderMax\Structs\TotalFareType $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
