<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItineraries Structs
 * Meta informations extracted from the WSDL
 * - documentation: Low Fare priced itineraries container. | Low Fare priced itineraries container. | Low Fare priced itineraries container. | Low Fare priced itineraries container.
 * @subpackage Structs
 */
class PricedItineraries extends AbstractStructBase
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - documentation: Successfull Low Fare priced itineraries in response to a Low Fare Search request. | Successfull Low Fare priced itineraries in response to a Low Fare Search request. | Successfull Low Fare priced itineraries in response to a Low Fare
     * Search request. | Successfull Low Fare priced itineraries in response to a Low Fare Search request.
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\PricedItineraryType[]
     */
    public $PricedItinerary;
    /**
     * Constructor method for PricedItineraries
     * @uses PricedItineraries::setTPA_Extensions()
     * @uses PricedItineraries::setPricedItinerary()
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType[] $pricedItinerary
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, array $pricedItinerary = array())
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricedItinerary($pricedItinerary);
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraries
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PricedItinerary value
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType[] $pricedItinerary
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraries
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType $item
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraries
     */
    public function addToPricedItinerary(\Sabre\BargainFinderMax\Structs\PricedItineraryType $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
