<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Preference Structs
 * @subpackage Structs
 */
class Preference extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Code;
    /**
     * The Level
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Level;
    /**
     * Constructor method for Preference
     * @uses Preference::setCode()
     * @uses Preference::setLevel()
     * @param string $code
     * @param string $level
     */
    public function __construct($code = null, $level = null)
    {
        $this
            ->setCode($code)
            ->setLevel($level);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\Preference
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Level value
     * @return string
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \Sabre\BargainFinderMax\Enums\ValidatingCarrierPreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\ValidatingCarrierPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \Sabre\BargainFinderMax\Structs\Preference
     */
    public function setLevel($level = null)
    {
        $this->Level = $level;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Preference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
