<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Penalty Structs
 * Meta informations extracted from the WSDL
 * - documentation: Penalty Info | Penalty Info | The penalty charge defined a fee in terms of its amount, currency and decimal laces. | Specifies penalty charges as either a currency amount or a percentage of the fare. | The penalty charge defined a
 * fee in terms of its amount, currency and decimal laces. | Specifies penalty charges as either a currency amount or a percentage of the fare. | The penalty charge defined a fee in terms of its amount, currency and decimal laces.
 * @subpackage Structs
 */
class Penalty extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Exclude
     * Meta informations extracted from the WSDL
     * - documentation: Indicate that specific penalty type should be excluded from the response.
     * - use: optional
     * @var bool
     */
    public $Exclude;
    /**
     * The Application
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Application;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Penalty Charge Amount | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: A currency code (e.g. USD, EUR, PLN) | A currency code (e.g. USD, EUR, PLN) | Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit". | Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217
     * standard "minor unit".
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The PenaltyType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the type of penalty involved in the search or response.
     * - use: optional
     * @var string
     */
    public $PenaltyType;
    /**
     * The DepartureStatus
     * Meta informations extracted from the WSDL
     * - documentation: Identifier used to indicate whether the change occurs before or after departure from the origin city.
     * - use: optional
     * @var string
     */
    public $DepartureStatus;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: The penalty charge conveyed as a percent of the total fare. | Used for percentage values
     * - maxInclusive: 100.00
     * - minInclusive: 0.01
     * @var float
     */
    public $Percent;
    /**
     * The Cat16TextOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Cat16TextOnly[]
     */
    public $Cat16TextOnly;
    /**
     * The Applicability
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Applicability;
    /**
     * The Refundable
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Refundable;
    /**
     * The Changeable
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Changeable;
    /**
     * The ConditionsApply
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $ConditionsApply;
    /**
     * The Cat16Info
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $Cat16Info;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Penalty Charge Currency | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for Penalty
     * @uses Penalty::setType()
     * @uses Penalty::setExclude()
     * @uses Penalty::setApplication()
     * @uses Penalty::setAmount()
     * @uses Penalty::setCurrencyCode()
     * @uses Penalty::setDecimalPlaces()
     * @uses Penalty::setPenaltyType()
     * @uses Penalty::setDepartureStatus()
     * @uses Penalty::setPercent()
     * @uses Penalty::setCat16TextOnly()
     * @uses Penalty::setApplicability()
     * @uses Penalty::setRefundable()
     * @uses Penalty::setChangeable()
     * @uses Penalty::setConditionsApply()
     * @uses Penalty::setCat16Info()
     * @uses Penalty::setCurrency()
     * @param string $type
     * @param bool $exclude
     * @param string $application
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $penaltyType
     * @param string $departureStatus
     * @param float $percent
     * @param \Sabre\BargainFinderMax\Structs\Cat16TextOnly[] $cat16TextOnly
     * @param string $applicability
     * @param bool $refundable
     * @param bool $changeable
     * @param bool $conditionsApply
     * @param bool $cat16Info
     * @param string $currency
     */
    public function __construct($type = null, $exclude = null, $application = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $penaltyType = null, $departureStatus = null, $percent = null, array $cat16TextOnly = array(), $applicability = null, $refundable = null, $changeable = null, $conditionsApply = false, $cat16Info = false, $currency = null)
    {
        $this
            ->setType($type)
            ->setExclude($exclude)
            ->setApplication($application)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setPenaltyType($penaltyType)
            ->setDepartureStatus($departureStatus)
            ->setPercent($percent)
            ->setCat16TextOnly($cat16TextOnly)
            ->setApplicability($applicability)
            ->setRefundable($refundable)
            ->setChangeable($changeable)
            ->setConditionsApply($conditionsApply)
            ->setCat16Info($cat16Info)
            ->setCurrency($currency);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setExclude($exclude = null)
    {
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setApplication($application = null)
    {
        $this->Application = $application;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get PenaltyType value
     * @return string|null
     */
    public function getPenaltyType()
    {
        return $this->PenaltyType;
    }
    /**
     * Set PenaltyType value
     * @param string $penaltyType
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setPenaltyType($penaltyType = null)
    {
        $this->PenaltyType = $penaltyType;
        return $this;
    }
    /**
     * Get DepartureStatus value
     * @return string|null
     */
    public function getDepartureStatus()
    {
        return $this->DepartureStatus;
    }
    /**
     * Set DepartureStatus value
     * @param string $departureStatus
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setDepartureStatus($departureStatus = null)
    {
        $this->DepartureStatus = $departureStatus;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Cat16TextOnly value
     * @return \Sabre\BargainFinderMax\Structs\Cat16TextOnly[]|null
     */
    public function getCat16TextOnly()
    {
        return $this->Cat16TextOnly;
    }
    /**
     * Set Cat16TextOnly value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Cat16TextOnly[] $cat16TextOnly
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setCat16TextOnly(array $cat16TextOnly = array())
    {
        $this->Cat16TextOnly = $cat16TextOnly;
        return $this;
    }
    /**
     * Add item to Cat16TextOnly value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Cat16TextOnly $item
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function addToCat16TextOnly(\Sabre\BargainFinderMax\Structs\Cat16TextOnly $item)
    {
        $this->Cat16TextOnly[] = $item;
        return $this;
    }
    /**
     * Get Applicability value
     * @return string|null
     */
    public function getApplicability()
    {
        return $this->Applicability;
    }
    /**
     * Set Applicability value
     * @param string $applicability
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setApplicability($applicability = null)
    {
        $this->Applicability = $applicability;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setRefundable($refundable = null)
    {
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get Changeable value
     * @return bool|null
     */
    public function getChangeable()
    {
        return $this->Changeable;
    }
    /**
     * Set Changeable value
     * @param bool $changeable
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setChangeable($changeable = null)
    {
        $this->Changeable = $changeable;
        return $this;
    }
    /**
     * Get ConditionsApply value
     * @return bool|null
     */
    public function getConditionsApply()
    {
        return $this->ConditionsApply;
    }
    /**
     * Set ConditionsApply value
     * @param bool $conditionsApply
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setConditionsApply($conditionsApply = false)
    {
        $this->ConditionsApply = $conditionsApply;
        return $this;
    }
    /**
     * Get Cat16Info value
     * @return bool|null
     */
    public function getCat16Info()
    {
        return $this->Cat16Info;
    }
    /**
     * Set Cat16Info value
     * @param bool $cat16Info
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setCat16Info($cat16Info = false)
    {
        $this->Cat16Info = $cat16Info;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Penalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
