<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerTypeQuantityType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies a PTC (Passenger Type Code) and the associated number of PTC's - for use in specifying passenger lists.
 * @subpackage Structs
 */
class PassengerTypeQuantityType extends TravelerCountType
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The Changeable
     * Meta informations extracted from the WSDL
     * - default: true
     * - use: optional
     * @var bool
     */
    public $Changeable;
    /**
     * The Index
     * Meta informations extracted from the WSDL
     * - documentation: Allows to identify which one of requested passengers this solution relates to.
     * @var int
     */
    public $Index;
    /**
     * The RequestedPassengerIndex
     * Meta informations extracted from the WSDL
     * - documentation: Allows to identify which one of requested passenger groups from Exchange request this solution relates to.
     * - use: optional
     * @var int
     */
    public $RequestedPassengerIndex;
    /**
     * Constructor method for PassengerTypeQuantityType
     * @uses PassengerTypeQuantityType::setTPA_Extensions()
     * @uses PassengerTypeQuantityType::setChangeable()
     * @uses PassengerTypeQuantityType::setIndex()
     * @uses PassengerTypeQuantityType::setRequestedPassengerIndex()
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param bool $changeable
     * @param int $index
     * @param int $requestedPassengerIndex
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $changeable = true, $index = null, $requestedPassengerIndex = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setChangeable($changeable)
            ->setIndex($index)
            ->setRequestedPassengerIndex($requestedPassengerIndex);
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Changeable value
     * @return bool|null
     */
    public function getChangeable()
    {
        return $this->Changeable;
    }
    /**
     * Set Changeable value
     * @param bool $changeable
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public function setChangeable($changeable = true)
    {
        $this->Changeable = $changeable;
        return $this;
    }
    /**
     * Get Index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public function setIndex($index = null)
    {
        $this->Index = $index;
        return $this;
    }
    /**
     * Get RequestedPassengerIndex value
     * @return int|null
     */
    public function getRequestedPassengerIndex()
    {
        return $this->RequestedPassengerIndex;
    }
    /**
     * Set RequestedPassengerIndex value
     * @param int $requestedPassengerIndex
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public function setRequestedPassengerIndex($requestedPassengerIndex = null)
    {
        $this->RequestedPassengerIndex = $requestedPassengerIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
