<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerInformationType Structs
 * @subpackage Structs
 */
class PassengerInformationType extends AbstractStructBase
{
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - documentation: Passenger type | Passenger code type
     * - use: required
     * - pattern: [A-Z][A-Z0-9]{2}
     * @var string
     */
    public $PassengerType;
    /**
     * The FareComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\FareComponentIDType[]
     */
    public $FareComponent;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxIDType[]
     */
    public $Tax;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[]
     */
    public $TaxSummary;
    /**
     * The OBFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OBFeeIDType[]
     */
    public $OBFee;
    /**
     * The CurrencyConversion
     * Meta informations extracted from the WSDL
     * - documentation: Currency conversion
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyConversionType
     */
    public $CurrencyConversion;
    /**
     * The FareMessage
     * Meta informations extracted from the WSDL
     * - documentation: Passenger fare message
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareMessageType[]
     */
    public $FareMessage;
    /**
     * The SellingFareData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SellingFareDataType[]
     */
    public $SellingFareData;
    /**
     * The PlusUp
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PlusUpInformationType[]
     */
    public $PlusUp;
    /**
     * The Reissue
     * Meta informations extracted from the WSDL
     * - documentation: Reissue price info
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public $Reissue;
    /**
     * The PassengerTotalFare
     * Meta informations extracted from the WSDL
     * - documentation: Passanger total fare
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public $PassengerTotalFare;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PricingLegType[]
     */
    public $Leg;
    /**
     * The BaggageInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BaggageInformationType[]
     */
    public $BaggageInformation;
    /**
     * The PenaltiesInfo
     * Meta informations extracted from the WSDL
     * - documentation: Penalties information
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PenaltiesType
     */
    public $PenaltiesInfo;
    /**
     * The ValidatingCarrierCommissionInfo
     * Meta informations extracted from the WSDL
     * - documentation: Validating Carrier Commission Information
     * - maxOccurs: 23
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ValidatingCarrierCommissionInfoType[]
     */
    public $ValidatingCarrierCommissionInfo;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - documentation: Total number of passengers
     * @var int
     */
    public $Total;
    /**
     * The PassengerNumber
     * Meta informations extracted from the WSDL
     * - default: 1
     * - documentation: Passenger number
     * - use: optional
     * @var int
     */
    public $PassengerNumber;
    /**
     * The Stopover
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Stopover
     * - use: optional
     * @var int
     */
    public $Stopover;
    /**
     * The NonRefundable
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Non refundable indicator
     * - use: optional
     * @var bool
     */
    public $NonRefundable;
    /**
     * The Divide
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Divide by party
     * - use: optional
     * @var bool
     */
    public $Divide;
    /**
     * Constructor method for PassengerInformationType
     * @uses PassengerInformationType::setPassengerType()
     * @uses PassengerInformationType::setFareComponent()
     * @uses PassengerInformationType::setTax()
     * @uses PassengerInformationType::setTaxSummary()
     * @uses PassengerInformationType::setOBFee()
     * @uses PassengerInformationType::setCurrencyConversion()
     * @uses PassengerInformationType::setFareMessage()
     * @uses PassengerInformationType::setSellingFareData()
     * @uses PassengerInformationType::setPlusUp()
     * @uses PassengerInformationType::setReissue()
     * @uses PassengerInformationType::setPassengerTotalFare()
     * @uses PassengerInformationType::setLeg()
     * @uses PassengerInformationType::setBaggageInformation()
     * @uses PassengerInformationType::setPenaltiesInfo()
     * @uses PassengerInformationType::setValidatingCarrierCommissionInfo()
     * @uses PassengerInformationType::setTotal()
     * @uses PassengerInformationType::setPassengerNumber()
     * @uses PassengerInformationType::setStopover()
     * @uses PassengerInformationType::setNonRefundable()
     * @uses PassengerInformationType::setDivide()
     * @param string $passengerType
     * @param \Sabre\BargainFinderMax\Structs\FareComponentIDType[] $fareComponent
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType[] $tax
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[] $taxSummary
     * @param \Sabre\BargainFinderMax\Structs\OBFeeIDType[] $oBFee
     * @param \Sabre\BargainFinderMax\Structs\CurrencyConversionType $currencyConversion
     * @param \Sabre\BargainFinderMax\Structs\FareMessageType[] $fareMessage
     * @param \Sabre\BargainFinderMax\Structs\SellingFareDataType[] $sellingFareData
     * @param \Sabre\BargainFinderMax\Structs\PlusUpInformationType[] $plusUp
     * @param \Sabre\BargainFinderMax\Structs\ReissueType $reissue
     * @param \Sabre\BargainFinderMax\Structs\PassengerTotalFareType $passengerTotalFare
     * @param \Sabre\BargainFinderMax\Structs\PricingLegType[] $leg
     * @param \Sabre\BargainFinderMax\Structs\BaggageInformationType[] $baggageInformation
     * @param \Sabre\BargainFinderMax\Structs\PenaltiesType $penaltiesInfo
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierCommissionInfoType[] $validatingCarrierCommissionInfo
     * @param int $total
     * @param int $passengerNumber
     * @param int $stopover
     * @param bool $nonRefundable
     * @param bool $divide
     */
    public function __construct($passengerType = null, array $fareComponent = array(), array $tax = array(), array $taxSummary = array(), array $oBFee = array(), \Sabre\BargainFinderMax\Structs\CurrencyConversionType $currencyConversion = null, array $fareMessage = array(), array $sellingFareData = array(), array $plusUp = array(), \Sabre\BargainFinderMax\Structs\ReissueType $reissue = null, \Sabre\BargainFinderMax\Structs\PassengerTotalFareType $passengerTotalFare = null, array $leg = array(), array $baggageInformation = array(), \Sabre\BargainFinderMax\Structs\PenaltiesType $penaltiesInfo = null, array $validatingCarrierCommissionInfo = array(), $total = null, $passengerNumber = '1', $stopover = '0', $nonRefundable = false, $divide = false)
    {
        $this
            ->setPassengerType($passengerType)
            ->setFareComponent($fareComponent)
            ->setTax($tax)
            ->setTaxSummary($taxSummary)
            ->setOBFee($oBFee)
            ->setCurrencyConversion($currencyConversion)
            ->setFareMessage($fareMessage)
            ->setSellingFareData($sellingFareData)
            ->setPlusUp($plusUp)
            ->setReissue($reissue)
            ->setPassengerTotalFare($passengerTotalFare)
            ->setLeg($leg)
            ->setBaggageInformation($baggageInformation)
            ->setPenaltiesInfo($penaltiesInfo)
            ->setValidatingCarrierCommissionInfo($validatingCarrierCommissionInfo)
            ->setTotal($total)
            ->setPassengerNumber($passengerNumber)
            ->setStopover($stopover)
            ->setNonRefundable($nonRefundable)
            ->setDivide($divide);
    }
    /**
     * Get PassengerType value
     * @return string
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareComponentIDType[] $fareComponent
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setFareComponent(array $fareComponent = array())
    {
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareComponentIDType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToFareComponent(\Sabre\BargainFinderMax\Structs\FareComponentIDType $item)
    {
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\TaxIDType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType[] $tax
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToTax(\Sabre\BargainFinderMax\Structs\TaxIDType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\TaxSummaryIDType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get OBFee value
     * @return \Sabre\BargainFinderMax\Structs\OBFeeIDType[]|null
     */
    public function getOBFee()
    {
        return $this->OBFee;
    }
    /**
     * Set OBFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OBFeeIDType[] $oBFee
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setOBFee(array $oBFee = array())
    {
        $this->OBFee = $oBFee;
        return $this;
    }
    /**
     * Add item to OBFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OBFeeIDType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToOBFee(\Sabre\BargainFinderMax\Structs\OBFeeIDType $item)
    {
        $this->OBFee[] = $item;
        return $this;
    }
    /**
     * Get CurrencyConversion value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionType|null
     */
    public function getCurrencyConversion()
    {
        return $this->CurrencyConversion;
    }
    /**
     * Set CurrencyConversion value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyConversionType $currencyConversion
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setCurrencyConversion(\Sabre\BargainFinderMax\Structs\CurrencyConversionType $currencyConversion = null)
    {
        $this->CurrencyConversion = $currencyConversion;
        return $this;
    }
    /**
     * Get FareMessage value
     * @return \Sabre\BargainFinderMax\Structs\FareMessageType[]|null
     */
    public function getFareMessage()
    {
        return $this->FareMessage;
    }
    /**
     * Set FareMessage value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareMessageType[] $fareMessage
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setFareMessage(array $fareMessage = array())
    {
        $this->FareMessage = $fareMessage;
        return $this;
    }
    /**
     * Add item to FareMessage value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareMessageType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToFareMessage(\Sabre\BargainFinderMax\Structs\FareMessageType $item)
    {
        $this->FareMessage[] = $item;
        return $this;
    }
    /**
     * Get SellingFareData value
     * @return \Sabre\BargainFinderMax\Structs\SellingFareDataType[]|null
     */
    public function getSellingFareData()
    {
        return $this->SellingFareData;
    }
    /**
     * Set SellingFareData value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SellingFareDataType[] $sellingFareData
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setSellingFareData(array $sellingFareData = array())
    {
        $this->SellingFareData = $sellingFareData;
        return $this;
    }
    /**
     * Add item to SellingFareData value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SellingFareDataType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToSellingFareData(\Sabre\BargainFinderMax\Structs\SellingFareDataType $item)
    {
        $this->SellingFareData[] = $item;
        return $this;
    }
    /**
     * Get PlusUp value
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType[]|null
     */
    public function getPlusUp()
    {
        return $this->PlusUp;
    }
    /**
     * Set PlusUp value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PlusUpInformationType[] $plusUp
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setPlusUp(array $plusUp = array())
    {
        $this->PlusUp = $plusUp;
        return $this;
    }
    /**
     * Add item to PlusUp value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PlusUpInformationType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToPlusUp(\Sabre\BargainFinderMax\Structs\PlusUpInformationType $item)
    {
        $this->PlusUp[] = $item;
        return $this;
    }
    /**
     * Get Reissue value
     * @return \Sabre\BargainFinderMax\Structs\ReissueType|null
     */
    public function getReissue()
    {
        return $this->Reissue;
    }
    /**
     * Set Reissue value
     * @param \Sabre\BargainFinderMax\Structs\ReissueType $reissue
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setReissue(\Sabre\BargainFinderMax\Structs\ReissueType $reissue = null)
    {
        $this->Reissue = $reissue;
        return $this;
    }
    /**
     * Get PassengerTotalFare value
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType|null
     */
    public function getPassengerTotalFare()
    {
        return $this->PassengerTotalFare;
    }
    /**
     * Set PassengerTotalFare value
     * @param \Sabre\BargainFinderMax\Structs\PassengerTotalFareType $passengerTotalFare
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setPassengerTotalFare(\Sabre\BargainFinderMax\Structs\PassengerTotalFareType $passengerTotalFare = null)
    {
        $this->PassengerTotalFare = $passengerTotalFare;
        return $this;
    }
    /**
     * Get Leg value
     * @return \Sabre\BargainFinderMax\Structs\PricingLegType[]|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricingLegType[] $leg
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setLeg(array $leg = array())
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Add item to Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricingLegType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToLeg(\Sabre\BargainFinderMax\Structs\PricingLegType $item)
    {
        $this->Leg[] = $item;
        return $this;
    }
    /**
     * Get BaggageInformation value
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType[]|null
     */
    public function getBaggageInformation()
    {
        return $this->BaggageInformation;
    }
    /**
     * Set BaggageInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BaggageInformationType[] $baggageInformation
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setBaggageInformation(array $baggageInformation = array())
    {
        $this->BaggageInformation = $baggageInformation;
        return $this;
    }
    /**
     * Add item to BaggageInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BaggageInformationType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToBaggageInformation(\Sabre\BargainFinderMax\Structs\BaggageInformationType $item)
    {
        $this->BaggageInformation[] = $item;
        return $this;
    }
    /**
     * Get PenaltiesInfo value
     * @return \Sabre\BargainFinderMax\Structs\PenaltiesType|null
     */
    public function getPenaltiesInfo()
    {
        return $this->PenaltiesInfo;
    }
    /**
     * Set PenaltiesInfo value
     * @param \Sabre\BargainFinderMax\Structs\PenaltiesType $penaltiesInfo
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setPenaltiesInfo(\Sabre\BargainFinderMax\Structs\PenaltiesType $penaltiesInfo = null)
    {
        $this->PenaltiesInfo = $penaltiesInfo;
        return $this;
    }
    /**
     * Get ValidatingCarrierCommissionInfo value
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCommissionInfoType[]|null
     */
    public function getValidatingCarrierCommissionInfo()
    {
        return $this->ValidatingCarrierCommissionInfo;
    }
    /**
     * Set ValidatingCarrierCommissionInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierCommissionInfoType[] $validatingCarrierCommissionInfo
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setValidatingCarrierCommissionInfo(array $validatingCarrierCommissionInfo = array())
    {
        $this->ValidatingCarrierCommissionInfo = $validatingCarrierCommissionInfo;
        return $this;
    }
    /**
     * Add item to ValidatingCarrierCommissionInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierCommissionInfoType $item
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function addToValidatingCarrierCommissionInfo(\Sabre\BargainFinderMax\Structs\ValidatingCarrierCommissionInfoType $item)
    {
        $this->ValidatingCarrierCommissionInfo[] = $item;
        return $this;
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get PassengerNumber value
     * @return int|null
     */
    public function getPassengerNumber()
    {
        return $this->PassengerNumber;
    }
    /**
     * Set PassengerNumber value
     * @param int $passengerNumber
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setPassengerNumber($passengerNumber = '1')
    {
        $this->PassengerNumber = $passengerNumber;
        return $this;
    }
    /**
     * Get Stopover value
     * @return int|null
     */
    public function getStopover()
    {
        return $this->Stopover;
    }
    /**
     * Set Stopover value
     * @param int $stopover
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setStopover($stopover = '0')
    {
        $this->Stopover = $stopover;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setNonRefundable($nonRefundable = false)
    {
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get Divide value
     * @return bool|null
     */
    public function getDivide()
    {
        return $this->Divide;
    }
    /**
     * Set Divide value
     * @param bool $divide
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public function setDivide($divide = false)
    {
        $this->Divide = $divide;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
