<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Override Structs
 * @subpackage Structs
 */
class Override extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Code;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - use: required
     * - pattern: [1-9][0-9]*|0%?|100%|[1-9][0-9]?%
     * @var string
     */
    public $Options;
    /**
     * Constructor method for Override
     * @uses Override::setCode()
     * @uses Override::setOptions()
     * @param string $code
     * @param string $options
     */
    public function __construct($code = null, $options = null)
    {
        $this
            ->setCode($code)
            ->setOptions($options);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\Override
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Options value
     * @return string
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param string $options
     * @return \Sabre\BargainFinderMax\Structs\Override
     */
    public function setOptions($options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Override
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
