<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Origin and Destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * @subpackage Structs
 */
class OriginDestinationInformationType extends TravelDateTimeType
{
    /**
     * The OriginLocation
     * @var \Sabre\BargainFinderMax\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \Sabre\BargainFinderMax\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The ConnectionLocations
     * Meta informations extracted from the WSDL
     * - documentation: Travel Connection Location - for example, air uses the IATA 3 letter code.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ConnectionType
     */
    public $ConnectionLocations;
    /**
     * Constructor method for OriginDestinationInformationType
     * @uses OriginDestinationInformationType::setOriginLocation()
     * @uses OriginDestinationInformationType::setDestinationLocation()
     * @uses OriginDestinationInformationType::setConnectionLocations()
     * @param \Sabre\BargainFinderMax\Structs\OriginLocation $originLocation
     * @param \Sabre\BargainFinderMax\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\OriginLocation $originLocation = null, \Sabre\BargainFinderMax\Structs\DestinationLocation $destinationLocation = null, \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setConnectionLocations($connectionLocations);
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\BargainFinderMax\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\BargainFinderMax\Structs\OriginLocation $originLocation
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformationType
     */
    public function setOriginLocation(\Sabre\BargainFinderMax\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\BargainFinderMax\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\BargainFinderMax\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformationType
     */
    public function setDestinationLocation(\Sabre\BargainFinderMax\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get ConnectionLocations value
     * @return \Sabre\BargainFinderMax\Structs\ConnectionType|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformationType
     */
    public function setConnectionLocations(\Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
