<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumTripsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element allows a user to specify the number of itineraries returned.
 * @subpackage Structs
 */
class NumTripsType extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - default: 9
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The PerDateMin
     * Meta informations extracted from the WSDL
     * - documentation: Minimum number of options to be retrieved for each combination of outbound/inbound dates.
     * - use: optional
     * @var int
     */
    public $PerDateMin;
    /**
     * The PerDateMax
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of options to be retrieved for each combination of outbound/inbound dates.
     * - use: optional
     * @var int
     */
    public $PerDateMax;
    /**
     * The PerMarket
     * Meta informations extracted from the WSDL
     * - documentation: Number of itineraries per market for alternate cities request. It allows to control market diversity only.
     * - use: optional
     * @var int
     */
    public $PerMarket;
    /**
     * The PerMonth
     * Meta informations extracted from the WSDL
     * - documentation: In Advanced Calendar API: Maximum number of itineraries to be retrieved for each departure month and departure/arrival combination.
     * - use: optional
     * @var int
     */
    public $PerMonth;
    /**
     * Constructor method for NumTripsType
     * @uses NumTripsType::setNumber()
     * @uses NumTripsType::setPerDateMin()
     * @uses NumTripsType::setPerDateMax()
     * @uses NumTripsType::setPerMarket()
     * @uses NumTripsType::setPerMonth()
     * @param string $number
     * @param int $perDateMin
     * @param int $perDateMax
     * @param int $perMarket
     * @param int $perMonth
     */
    public function __construct($number = '9', $perDateMin = null, $perDateMax = null, $perMarket = null, $perMonth = null)
    {
        $this
            ->setNumber($number)
            ->setPerDateMin($perDateMin)
            ->setPerDateMax($perDateMax)
            ->setPerMarket($perMarket)
            ->setPerMonth($perMonth);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\BargainFinderMax\Structs\NumTripsType
     */
    public function setNumber($number = '9')
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get PerDateMin value
     * @return int|null
     */
    public function getPerDateMin()
    {
        return $this->PerDateMin;
    }
    /**
     * Set PerDateMin value
     * @param int $perDateMin
     * @return \Sabre\BargainFinderMax\Structs\NumTripsType
     */
    public function setPerDateMin($perDateMin = null)
    {
        $this->PerDateMin = $perDateMin;
        return $this;
    }
    /**
     * Get PerDateMax value
     * @return int|null
     */
    public function getPerDateMax()
    {
        return $this->PerDateMax;
    }
    /**
     * Set PerDateMax value
     * @param int $perDateMax
     * @return \Sabre\BargainFinderMax\Structs\NumTripsType
     */
    public function setPerDateMax($perDateMax = null)
    {
        $this->PerDateMax = $perDateMax;
        return $this;
    }
    /**
     * Get PerMarket value
     * @return int|null
     */
    public function getPerMarket()
    {
        return $this->PerMarket;
    }
    /**
     * Set PerMarket value
     * @param int $perMarket
     * @return \Sabre\BargainFinderMax\Structs\NumTripsType
     */
    public function setPerMarket($perMarket = null)
    {
        $this->PerMarket = $perMarket;
        return $this;
    }
    /**
     * Get PerMonth value
     * @return int|null
     */
    public function getPerMonth()
    {
        return $this->PerMonth;
    }
    /**
     * Set PerMonth value
     * @param int $perMonth
     * @return \Sabre\BargainFinderMax\Structs\NumTripsType
     */
    public function setPerMonth($perMonth = null)
    {
        $this->PerMonth = $perMonth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\NumTripsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
