<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinimumStay Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies restrictions for the shortest length/period of time or earliest day return travel can commence or be completed.
 * @subpackage Structs
 */
class MinimumStay extends AbstractStructBase
{
    /**
     * The ReturnTimeOfDay
     * Meta informations extracted from the WSDL
     * - documentation: The time of day when return travel may commence. | Allows for the specification of a date time or just time.
     * - use: optional
     * - union: string | time
     * @var string
     */
    public $ReturnTimeOfDay;
    /**
     * The MinStay
     * Meta informations extracted from the WSDL
     * - documentation: The amount of elapsed time or number of occurrences of a day of the week needed to satisfy a minimum stay requirement. | Used for Numeric values, from 1 to 99 inclusive
     * - use: optional
     * - maxInclusive: 99
     * - minInclusive: 1
     * @var int
     */
    public $MinStay;
    /**
     * The StayUnit
     * Meta informations extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week applied to the MinStay value.
     * - use: optional
     * @var string
     */
    public $StayUnit;
    /**
     * The MinStayDate
     * Meta informations extracted from the WSDL
     * - documentation: The specific date for the minimum stay requirement. | Allows for the specification of a date time or just time.
     * - use: optional
     * - union: string | time
     * @var string
     */
    public $MinStayDate;
    /**
     * Constructor method for MinimumStay
     * @uses MinimumStay::setReturnTimeOfDay()
     * @uses MinimumStay::setMinStay()
     * @uses MinimumStay::setStayUnit()
     * @uses MinimumStay::setMinStayDate()
     * @param string $returnTimeOfDay
     * @param int $minStay
     * @param string $stayUnit
     * @param string $minStayDate
     */
    public function __construct($returnTimeOfDay = null, $minStay = null, $stayUnit = null, $minStayDate = null)
    {
        $this
            ->setReturnTimeOfDay($returnTimeOfDay)
            ->setMinStay($minStay)
            ->setStayUnit($stayUnit)
            ->setMinStayDate($minStayDate);
    }
    /**
     * Get ReturnTimeOfDay value
     * @return string|null
     */
    public function getReturnTimeOfDay()
    {
        return $this->ReturnTimeOfDay;
    }
    /**
     * Set ReturnTimeOfDay value
     * @param string $returnTimeOfDay
     * @return \Sabre\BargainFinderMax\Structs\MinimumStay
     */
    public function setReturnTimeOfDay($returnTimeOfDay = null)
    {
        $this->ReturnTimeOfDay = $returnTimeOfDay;
        return $this;
    }
    /**
     * Get MinStay value
     * @return int|null
     */
    public function getMinStay()
    {
        return $this->MinStay;
    }
    /**
     * Set MinStay value
     * @param int $minStay
     * @return \Sabre\BargainFinderMax\Structs\MinimumStay
     */
    public function setMinStay($minStay = null)
    {
        $this->MinStay = $minStay;
        return $this;
    }
    /**
     * Get StayUnit value
     * @return string|null
     */
    public function getStayUnit()
    {
        return $this->StayUnit;
    }
    /**
     * Set StayUnit value
     * @uses \Sabre\BargainFinderMax\Enums\StayUnitType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\StayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayUnit
     * @return \Sabre\BargainFinderMax\Structs\MinimumStay
     */
    public function setStayUnit($stayUnit = null)
    {
        $this->StayUnit = $stayUnit;
        return $this;
    }
    /**
     * Get MinStayDate value
     * @return string|null
     */
    public function getMinStayDate()
    {
        return $this->MinStayDate;
    }
    /**
     * Set MinStayDate value
     * @param string $minStayDate
     * @return \Sabre\BargainFinderMax\Structs\MinimumStay
     */
    public function setMinStayDate($minStayDate = null)
    {
        $this->MinStayDate = $minStayDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\MinimumStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
