<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryType Structs
 * @subpackage Structs
 */
class ItineraryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary id (sequence number).
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Pricing Source name, e.g.: "ADVJR1". One ItineraryGroup can contain information from more than one pricing source, e.g from two JRs.
     * @var string
     */
    public $PricingSource;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\LegIDType[]
     */
    public $Leg;
    /**
     * The PricingInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PricingInformationType[]
     */
    public $PricingInformation;
    /**
     * The DiversitySwapper
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DiversitySwapperType
     */
    public $DiversitySwapper;
    /**
     * The Failed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FailedType
     */
    public $Failed;
    /**
     * The RoutingItinerary
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if itin come from custom carrier/routing path.
     * - use: optional
     * @var bool
     */
    public $RoutingItinerary;
    /**
     * The ItinSource
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ItinSource;
    /**
     * The CurrentItinerary
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Prices for current itinerary indicator. This indicates if this is WPNI or EXCHANGE itinerary.
     * - use: optional
     * @var bool
     */
    public $CurrentItinerary;
    /**
     * Constructor method for ItineraryType
     * @uses ItineraryType::setID()
     * @uses ItineraryType::setPricingSource()
     * @uses ItineraryType::setLeg()
     * @uses ItineraryType::setPricingInformation()
     * @uses ItineraryType::setDiversitySwapper()
     * @uses ItineraryType::setFailed()
     * @uses ItineraryType::setRoutingItinerary()
     * @uses ItineraryType::setItinSource()
     * @uses ItineraryType::setCurrentItinerary()
     * @param int $iD
     * @param string $pricingSource
     * @param \Sabre\BargainFinderMax\Structs\LegIDType[] $leg
     * @param \Sabre\BargainFinderMax\Structs\PricingInformationType[] $pricingInformation
     * @param \Sabre\BargainFinderMax\Structs\DiversitySwapperType $diversitySwapper
     * @param \Sabre\BargainFinderMax\Structs\FailedType $failed
     * @param bool $routingItinerary
     * @param string $itinSource
     * @param bool $currentItinerary
     */
    public function __construct($iD = null, $pricingSource = null, array $leg = array(), array $pricingInformation = array(), \Sabre\BargainFinderMax\Structs\DiversitySwapperType $diversitySwapper = null, \Sabre\BargainFinderMax\Structs\FailedType $failed = null, $routingItinerary = null, $itinSource = null, $currentItinerary = false)
    {
        $this
            ->setID($iD)
            ->setPricingSource($pricingSource)
            ->setLeg($leg)
            ->setPricingInformation($pricingInformation)
            ->setDiversitySwapper($diversitySwapper)
            ->setFailed($failed)
            ->setRoutingItinerary($routingItinerary)
            ->setItinSource($itinSource)
            ->setCurrentItinerary($currentItinerary);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Leg value
     * @return \Sabre\BargainFinderMax\Structs\LegIDType[]|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegIDType[] $leg
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setLeg(array $leg = array())
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Add item to Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegIDType $item
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function addToLeg(\Sabre\BargainFinderMax\Structs\LegIDType $item)
    {
        $this->Leg[] = $item;
        return $this;
    }
    /**
     * Get PricingInformation value
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType[]|null
     */
    public function getPricingInformation()
    {
        return $this->PricingInformation;
    }
    /**
     * Set PricingInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricingInformationType[] $pricingInformation
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setPricingInformation(array $pricingInformation = array())
    {
        $this->PricingInformation = $pricingInformation;
        return $this;
    }
    /**
     * Add item to PricingInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricingInformationType $item
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function addToPricingInformation(\Sabre\BargainFinderMax\Structs\PricingInformationType $item)
    {
        $this->PricingInformation[] = $item;
        return $this;
    }
    /**
     * Get DiversitySwapper value
     * @return \Sabre\BargainFinderMax\Structs\DiversitySwapperType|null
     */
    public function getDiversitySwapper()
    {
        return $this->DiversitySwapper;
    }
    /**
     * Set DiversitySwapper value
     * @param \Sabre\BargainFinderMax\Structs\DiversitySwapperType $diversitySwapper
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setDiversitySwapper(\Sabre\BargainFinderMax\Structs\DiversitySwapperType $diversitySwapper = null)
    {
        $this->DiversitySwapper = $diversitySwapper;
        return $this;
    }
    /**
     * Get Failed value
     * @return \Sabre\BargainFinderMax\Structs\FailedType|null
     */
    public function getFailed()
    {
        return $this->Failed;
    }
    /**
     * Set Failed value
     * @param \Sabre\BargainFinderMax\Structs\FailedType $failed
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setFailed(\Sabre\BargainFinderMax\Structs\FailedType $failed = null)
    {
        $this->Failed = $failed;
        return $this;
    }
    /**
     * Get RoutingItinerary value
     * @return bool|null
     */
    public function getRoutingItinerary()
    {
        return $this->RoutingItinerary;
    }
    /**
     * Set RoutingItinerary value
     * @param bool $routingItinerary
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setRoutingItinerary($routingItinerary = null)
    {
        $this->RoutingItinerary = $routingItinerary;
        return $this;
    }
    /**
     * Get ItinSource value
     * @return string|null
     */
    public function getItinSource()
    {
        return $this->ItinSource;
    }
    /**
     * Set ItinSource value
     * @param string $itinSource
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setItinSource($itinSource = null)
    {
        $this->ItinSource = $itinSource;
        return $this;
    }
    /**
     * Get CurrentItinerary value
     * @return bool|null
     */
    public function getCurrentItinerary()
    {
        return $this->CurrentItinerary;
    }
    /**
     * Set CurrentItinerary value
     * @param bool $currentItinerary
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public function setCurrentItinerary($currentItinerary = false)
    {
        $this->CurrentItinerary = $currentItinerary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
