<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryGroupType Structs
 * @subpackage Structs
 */
class ItineraryGroupType extends AbstractStructBase
{
    /**
     * The GroupDescription
     * @var \Sabre\BargainFinderMax\Structs\GroupDescription
     */
    public $GroupDescription;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - documentation: Flight Itinerary
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ItineraryType[]
     */
    public $Itinerary;
    /**
     * The ProcessingMessage
     * Meta informations extracted from the WSDL
     * - documentation: A message indicating that no schecules/no availabilities were found for the given market x date query. Typically you would expect either one message or a non-empty list of itineraries. It is possible though that you can get more than
     * one message or a message + itinerary list in case where this itinerary group merges the result from two services (e.r. two JR's).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ProcessingMessageType[]
     */
    public $ProcessingMessage;
    /**
     * Constructor method for ItineraryGroupType
     * @uses ItineraryGroupType::setGroupDescription()
     * @uses ItineraryGroupType::setItinerary()
     * @uses ItineraryGroupType::setProcessingMessage()
     * @param \Sabre\BargainFinderMax\Structs\GroupDescription $groupDescription
     * @param \Sabre\BargainFinderMax\Structs\ItineraryType[] $itinerary
     * @param \Sabre\BargainFinderMax\Structs\ProcessingMessageType[] $processingMessage
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\GroupDescription $groupDescription = null, array $itinerary = array(), array $processingMessage = array())
    {
        $this
            ->setGroupDescription($groupDescription)
            ->setItinerary($itinerary)
            ->setProcessingMessage($processingMessage);
    }
    /**
     * Get GroupDescription value
     * @return \Sabre\BargainFinderMax\Structs\GroupDescription|null
     */
    public function getGroupDescription()
    {
        return $this->GroupDescription;
    }
    /**
     * Set GroupDescription value
     * @param \Sabre\BargainFinderMax\Structs\GroupDescription $groupDescription
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType
     */
    public function setGroupDescription(\Sabre\BargainFinderMax\Structs\GroupDescription $groupDescription = null)
    {
        $this->GroupDescription = $groupDescription;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \Sabre\BargainFinderMax\Structs\ItineraryType[]|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ItineraryType[] $itinerary
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType
     */
    public function setItinerary(array $itinerary = array())
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Add item to Itinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ItineraryType $item
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType
     */
    public function addToItinerary(\Sabre\BargainFinderMax\Structs\ItineraryType $item)
    {
        $this->Itinerary[] = $item;
        return $this;
    }
    /**
     * Get ProcessingMessage value
     * @return \Sabre\BargainFinderMax\Structs\ProcessingMessageType[]|null
     */
    public function getProcessingMessage()
    {
        return $this->ProcessingMessage;
    }
    /**
     * Set ProcessingMessage value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ProcessingMessageType[] $processingMessage
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType
     */
    public function setProcessingMessage(array $processingMessage = array())
    {
        $this->ProcessingMessage = $processingMessage;
        return $this;
    }
    /**
     * Add item to ProcessingMessage value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ProcessingMessageType $item
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType
     */
    public function addToProcessingMessage(\Sabre\BargainFinderMax\Structs\ProcessingMessageType $item)
    {
        $this->ProcessingMessage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
